/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.renderers;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.portingdeadmods.portingdeadlibs.utils.renderers.Effects;
import com.portingdeadmods.portingdeadlibs.utils.renderers.PixelManipulator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;

public final class GuiUtils {
    private static final Map<ResourceLocation, DynamicTexture> DYNAMIC_TEXTURE_CACHE = new HashMap<ResourceLocation, DynamicTexture>();
    private static final TextureManager TEXTURE_MANAGER = Minecraft.getInstance().getTextureManager();

    public static void drawImg(GuiGraphics guiGraphics, ResourceLocation texturePath, int x, int y, int width, int height) {
        guiGraphics.blit(texturePath, x, y, 0, 0.0f, 0.0f, width, height, width, height);
    }

    public static void drawWithZ(GuiGraphics guiGraphics, ResourceLocation texturePath, int x, int y, int z, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texturePath);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, (float)z);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)y, 0.0f).setUv(0.0f / (float)width, 0.0f / (float)height);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)(y + height), 0.0f).setUv(0.0f / (float)width, (0.0f + (float)height) / (float)height);
        bufferbuilder.addVertex(matrix4f, (float)(x + width), (float)(y + height), 0.0f).setUv((0.0f + (float)width) / (float)width, (0.0f + (float)height) / (float)height);
        bufferbuilder.addVertex(matrix4f, (float)(x + width), (float)y, 0.0f).setUv((0.0f + (float)width) / (float)width, 0.0f / (float)height);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        poseStack.popPose();
    }

    public static void renderRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int lineWidth, int lineColor, int fillColor) {
        guiGraphics.fill(x, y, x + width, y + height, lineColor);
        guiGraphics.fill(x + lineWidth, y + lineWidth, x + width - lineWidth, y + height - lineWidth, fillColor);
    }

    private static NativeImage loadImage(ResourceLocation texturePath) throws IOException {
        Minecraft mc = Minecraft.getInstance();
        Optional resource = mc.getResourceManager().getResource(texturePath);
        if (resource.isPresent()) {
            try (InputStream stream = ((Resource)resource.get()).open();){
                NativeImage nativeImage = NativeImage.read((InputStream)stream);
                return nativeImage;
            }
        }
        throw new IOException("Could not load texture: " + String.valueOf(texturePath));
    }

    private static NativeImage copyImage(NativeImage original) {
        NativeImage copy = new NativeImage(original.getWidth(), original.getHeight(), false);
        copy.copyFrom(original);
        return copy;
    }

    private static NativeImage loadAndManipulateImage(ResourceLocation texturePath, PixelManipulator manipulator) throws IOException {
        NativeImage original = GuiUtils.loadImage(texturePath);
        NativeImage manipulated = new NativeImage(original.getWidth(), original.getHeight(), false);
        for (int y = 0; y < original.getHeight(); ++y) {
            for (int x = 0; x < original.getWidth(); ++x) {
                int originalColor = original.getPixelRGBA(x, y);
                int manipulatedColor = manipulator.manipulate(x, y, originalColor);
                manipulated.setPixelRGBA(x, y, manipulatedColor);
            }
        }
        original.close();
        return manipulated;
    }

    private static ResourceLocation createOrUpdateDynamicTexture(ResourceLocation basePath, NativeImage image) {
        String dynamicPath = basePath.toString() + "_dynamic";
        ResourceLocation dynamicLocation = ResourceLocation.parse((String)dynamicPath);
        if (DYNAMIC_TEXTURE_CACHE.containsKey(dynamicLocation)) {
            DynamicTexture oldTexture = DYNAMIC_TEXTURE_CACHE.get(dynamicLocation);
            oldTexture.close();
        }
        DynamicTexture dynamicTexture = new DynamicTexture(image);
        DYNAMIC_TEXTURE_CACHE.put(dynamicLocation, dynamicTexture);
        TEXTURE_MANAGER.register(dynamicLocation, (AbstractTexture)dynamicTexture);
        return dynamicLocation;
    }

    public static void cleanupDynamicTextures() {
        DYNAMIC_TEXTURE_CACHE.forEach((location, texture) -> {
            texture.close();
            TEXTURE_MANAGER.release(location);
        });
        DYNAMIC_TEXTURE_CACHE.clear();
    }

    public static void drawBlending(GuiGraphics guiGraphics, ResourceLocation texturePath, int x, int y, int width, int height, BlendMode blendMode) {
        RenderSystem.enableBlend();
        switch (blendMode.ordinal()) {
            case 0: {
                RenderSystem.blendFunc((int)774, (int)771);
                break;
            }
            case 1: {
                RenderSystem.blendFunc((int)770, (int)1);
                break;
            }
            case 2: {
                RenderSystem.blendEquation((int)32775);
                RenderSystem.blendFunc((int)1, (int)1);
                break;
            }
            case 3: {
                RenderSystem.blendEquation((int)32776);
                RenderSystem.blendFunc((int)1, (int)1);
                break;
            }
            case 4: {
                RenderSystem.blendEquation((int)32779);
                RenderSystem.blendFunc((int)1, (int)1);
                break;
            }
            default: {
                RenderSystem.defaultBlendFunc();
            }
        }
        GuiUtils.drawImg(guiGraphics, texturePath, x, y, width, height);
        RenderSystem.blendEquation((int)32774);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static enum BlendMode {
        MULTIPLY,
        ADD,
        DARKEN,
        LIGHTEN,
        DIFFERENCE;

    }

    public static class ShaderChain {
        private final List<Effects.PixelEffect> effects = new ArrayList<Effects.PixelEffect>();
        private boolean cacheResult = false;
        private String cacheKey = null;

        private ShaderChain() {
        }

        public static ShaderChain create() {
            return new ShaderChain();
        }

        public ShaderChain then(PixelManipulator manipulator) {
            this.effects.add(new Effects.CustomEffect(manipulator));
            return this;
        }

        public ShaderChain then(String name, PixelManipulator manipulator) {
            this.effects.add(new Effects.NamedEffect(name, manipulator));
            return this;
        }

        public ShaderChain grayscale() {
            this.effects.add(new Effects.Grayscale());
            return this;
        }

        public ShaderChain invert() {
            this.effects.add(new Effects.Invert());
            return this;
        }

        public ShaderChain brightness(float factor) {
            this.effects.add(new Effects.Brightness(factor));
            return this;
        }

        public ShaderChain contrast(float factor) {
            this.effects.add(new Effects.Contrast(factor));
            return this;
        }

        public ShaderChain tint(int color, float strength) {
            this.effects.add(new Effects.Tint(color, strength));
            return this;
        }

        public ShaderChain colorFilter(float r, float g, float b) {
            this.effects.add(new Effects.ColorFilter(r, g, b));
            return this;
        }

        public ShaderChain hueShift(float degrees) {
            this.effects.add(new Effects.HueShift(degrees));
            return this;
        }

        public ShaderChain saturation(float factor) {
            this.effects.add(new Effects.Saturation(factor));
            return this;
        }

        public ShaderChain sepia() {
            this.effects.add(new Effects.Sepia());
            return this;
        }

        public ShaderChain gamma(float gamma) {
            this.effects.add(new Effects.Gamma(gamma));
            return this;
        }

        public ShaderChain threshold(int threshold) {
            this.effects.add(new Effects.Threshold(threshold));
            return this;
        }

        public ShaderChain pixelate(int pixelSize) {
            this.effects.add(new Effects.Pixelate(pixelSize));
            return this;
        }

        public ShaderChain noise(float intensity) {
            this.effects.add(new Effects.Noise(intensity));
            return this;
        }

        public ShaderChain edgeDetect(int edgeColor, int threshold) {
            this.effects.add(new Effects.EdgeDetect(edgeColor, threshold));
            return this;
        }

        public ShaderChain blur(int radius) {
            this.effects.add(new Effects.Blur(radius));
            return this;
        }

        public ShaderChain sharpen(float strength) {
            this.effects.add(new Effects.Sharpen(strength));
            return this;
        }

        public ShaderChain emboss() {
            this.effects.add(new Effects.Emboss());
            return this;
        }

        public ShaderChain mirrorHorizontal() {
            this.effects.add(new Effects.Mirror(Effects.Mirror.MirrorMode.HORIZONTAL));
            return this;
        }

        public ShaderChain mirrorVertical() {
            this.effects.add(new Effects.Mirror(Effects.Mirror.MirrorMode.VERTICAL));
            return this;
        }

        public ShaderChain mirrorBoth() {
            this.effects.add(new Effects.Mirror(Effects.Mirror.MirrorMode.BOTH));
            return this;
        }

        public ShaderChain mirror(Effects.Mirror.MirrorMode mode) {
            this.effects.add(new Effects.Mirror(mode));
            return this;
        }

        public ShaderChain cache(String key) {
            this.cacheResult = true;
            this.cacheKey = key;
            return this;
        }

        public NativeImage apply(NativeImage input) {
            NativeImage current = GuiUtils.copyImage(input);
            for (Effects.PixelEffect effect : this.effects) {
                NativeImage next = effect.apply(current);
                if (next == current) continue;
                current.close();
                current = next;
            }
            return current;
        }

        public void drawTo(GuiGraphics guiGraphics, ResourceLocation texturePath, int x, int y, int width, int height) {
            try {
                String cacheId;
                String string = cacheId = this.cacheKey != null ? this.cacheKey : this.generateCacheKey(texturePath);
                if (this.cacheResult && DYNAMIC_TEXTURE_CACHE.containsKey(ResourceLocation.parse((String)cacheId))) {
                    GuiUtils.drawImg(guiGraphics, ResourceLocation.parse((String)cacheId), x, y, width, height);
                    return;
                }
                NativeImage original = GuiUtils.loadImage(texturePath);
                NativeImage result = this.apply(original);
                original.close();
                ResourceLocation dynamicTexture = GuiUtils.createOrUpdateDynamicTexture(ResourceLocation.parse((String)cacheId), result);
                GuiUtils.drawImg(guiGraphics, dynamicTexture, x, y, width, height);
            }
            catch (IOException e) {
                GuiUtils.drawImg(guiGraphics, texturePath, x, y, width, height);
            }
        }

        public void drawTo(GuiGraphics guiGraphics, ResourceLocation texturePath, int x, int y, int width, int height, BlendMode blendMode) {
            try {
                String cacheId;
                String string = cacheId = this.cacheKey != null ? this.cacheKey : this.generateCacheKey(texturePath);
                if (this.cacheResult && DYNAMIC_TEXTURE_CACHE.containsKey(ResourceLocation.parse((String)cacheId))) {
                    GuiUtils.drawBlending(guiGraphics, ResourceLocation.parse((String)cacheId), x, y, width, height, blendMode);
                    return;
                }
                NativeImage original = GuiUtils.loadImage(texturePath);
                NativeImage result = this.apply(original);
                original.close();
                ResourceLocation dynamicTexture = GuiUtils.createOrUpdateDynamicTexture(ResourceLocation.parse((String)cacheId), result);
                GuiUtils.drawBlending(guiGraphics, dynamicTexture, x, y, width, height, blendMode);
            }
            catch (IOException e) {
                GuiUtils.drawBlending(guiGraphics, texturePath, x, y, width, height, blendMode);
            }
        }

        private String generateCacheKey(ResourceLocation base) {
            StringBuilder sb = new StringBuilder(base.toString());
            for (Effects.PixelEffect effect : this.effects) {
                sb.append("_").append(effect.getName());
            }
            return sb.toString();
        }
    }
}

