/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.recipes;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public record FluidIngredientWithAmount(FluidIngredient fluidIngredient, int amount) {
    public static final FluidIngredientWithAmount EMPTY = new FluidIngredientWithAmount(FluidIngredient.empty(), -1);
    private static final Codec<Pair<Integer, FluidIngredient>> PAIR_CODEC = Codec.pair((Codec)Codec.INT.optionalFieldOf("amount", (Object)1).codec(), (Codec)FluidIngredient.CODEC);
    public static final Codec<FluidIngredientWithAmount> CODEC = PAIR_CODEC.xmap(pair -> new FluidIngredientWithAmount((FluidIngredient)pair.getSecond(), (Integer)pair.getFirst()), iwc -> new Pair((Object)iwc.amount(), (Object)iwc.fluidIngredient()));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredientWithAmount> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, FluidIngredientWithAmount::fluidIngredient, (StreamCodec)ByteBufCodecs.INT, FluidIngredientWithAmount::amount, FluidIngredientWithAmount::new);

    public boolean test(FluidStack fluidStack) {
        return this.fluidIngredient.test(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public static FluidIngredientWithAmount of(FluidStack fluidStack) {
        return new FluidIngredientWithAmount(FluidIngredient.of((FluidStack[])new FluidStack[]{fluidStack}), fluidStack.getAmount());
    }

    public static FluidIngredientWithAmount of(TagKey<Fluid> fluidTagKey) {
        return new FluidIngredientWithAmount(FluidIngredient.tag(fluidTagKey), 1);
    }

    public static FluidIngredientWithAmount of(TagKey<Fluid> fluidTagKey, int amount) {
        return new FluidIngredientWithAmount(FluidIngredient.tag(fluidTagKey), amount);
    }

    public static FluidIngredientWithAmount of(Fluid fluid) {
        return new FluidIngredientWithAmount(FluidIngredient.of((Fluid[])new Fluid[]{fluid}), 1);
    }

    public static FluidIngredientWithAmount of(Fluid fluid, int amount) {
        return new FluidIngredientWithAmount(FluidIngredient.of((Fluid[])new Fluid[]{fluid}), amount);
    }
}

