/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.example;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.blocks.ContainerBlock;
import com.portingdeadmods.portingdeadlibs.example.ExampleContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.example.ExampleRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ExampleContainerBlock
extends ContainerBlock {
    public ExampleContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean tickingEnabled() {
        return false;
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ExampleRegistries.EXAMPLE_CONTAINER_BLOCK_ENTITY.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return ExampleContainerBlock.simpleCodec(ExampleContainerBlock::new);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExampleContainerBlockEntity) {
            ExampleContainerBlockEntity be = (ExampleContainerBlockEntity)blockEntity;
            be.getItemHandler().insertItem(0, new ItemStack((ItemLike)Items.DIAMOND, 10), false);
            be.getFluidHandler().fill(new FluidStack((Fluid)Fluids.WATER, 10), IFluidHandler.FluidAction.EXECUTE);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

