/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostPartMenuFactory;
import com.portingdeadmods.portingdeadlibs.api.gui.menus.PDLAbstractContainerMenu;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public abstract class GhostMultiblockControllerBE
extends ContainerBlockEntity
implements MenuProvider {
    public final Set<BlockPos> partPositions = new UniqueArray<BlockPos>();
    public final Map<BlockPos, List<ResourceLocation>> exposedHandlers = new HashMap<BlockPos, List<ResourceLocation>>();
    public final Map<BlockPos, GhostPartMenuFactory> partMenus = new HashMap<BlockPos, GhostPartMenuFactory>();
    @Nullable
    private BlockPos pendingMenuPart;

    public GhostMultiblockControllerBE(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setPartConfiguration(Set<BlockPos> partPositions, Map<BlockPos, List<ResourceLocation>> handlerExposure, Map<BlockPos, GhostPartMenuFactory> menuFactories) {
        this.partPositions.clear();
        handlerExposure.forEach((pos, handlers) -> Objects.requireNonNull(handlers, "Handler list cannot be null"));
        partPositions.forEach(pos -> this.partPositions.add(pos.immutable()));
        this.exposedHandlers.clear();
        handlerExposure.forEach((pos, handlers) -> this.exposedHandlers.put(pos.immutable(), List.copyOf(handlers)));
        this.partMenus.clear();
        menuFactories.forEach((pos, factory) -> this.partMenus.put(pos.immutable(), (GhostPartMenuFactory)factory));
        this.setChanged();
    }

    public Set<BlockPos> getPartPositions() {
        return Collections.unmodifiableSet(this.partPositions);
    }

    public Map<BlockPos, List<ResourceLocation>> getExposedHandlers() {
        return Collections.unmodifiableMap(this.exposedHandlers);
    }

    public boolean exposesHandler(ResourceLocation handlerKey, BlockPos partPos) {
        List<ResourceLocation> handlers = this.exposedHandlers.get(partPos);
        if (handlers == null) {
            return true;
        }
        return handlers.contains(handlerKey);
    }

    public <T> boolean exposesHandler(BlockCapability<T, @Nullable Direction> handler, BlockPos partPos) {
        return this.exposesHandler(handler.name(), partPos);
    }

    public void prepareMenu(@Nullable BlockPos partPos) {
        this.pendingMenuPart = partPos;
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveData(tag, registries);
        if (!this.partPositions.isEmpty()) {
            tag.putLongArray("part_positions", this.partPositions.stream().mapToLong(BlockPos::asLong).toArray());
        }
        if (!this.exposedHandlers.isEmpty()) {
            ListTag exposure = new ListTag();
            for (Map.Entry<BlockPos, List<ResourceLocation>> entry : this.exposedHandlers.entrySet()) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putLong("pos", entry.getKey().asLong());
                ListTag handlers = new ListTag();
                for (ResourceLocation id : entry.getValue()) {
                    handlers.add((Object)StringTag.valueOf((String)id.toString()));
                }
                entryTag.put("handlers", (Tag)handlers);
                exposure.add((Object)entryTag);
            }
            tag.put("handler_exposure", (Tag)exposure);
        }
        if (!this.partMenus.isEmpty()) {
            ListTag noMenu = new ListTag();
            for (Map.Entry<BlockPos, Object> entry : this.partMenus.entrySet()) {
                if (entry.getValue() != null) continue;
                noMenu.add((Object)LongTag.valueOf((long)entry.getKey().asLong()));
            }
            if (!noMenu.isEmpty()) {
                tag.put("no_part_menus", (Tag)noMenu);
            }
        }
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadData(tag, registries);
        this.partPositions.clear();
        this.exposedHandlers.clear();
        this.partMenus.clear();
        if (tag.contains("part_positions")) {
            long[] partPositionsArray;
            for (long posLong : partPositionsArray = tag.getLongArray("part_positions")) {
                this.partPositions.add(BlockPos.of((long)posLong));
            }
        }
        if (tag.contains("handler_exposure", 9)) {
            ListTag exposure = tag.getList("handler_exposure", 10);
            for (int i = 0; i < exposure.size(); ++i) {
                CompoundTag entry = exposure.getCompound(i);
                BlockPos pos = BlockPos.of((long)entry.getLong("pos"));
                ListTag handlers = entry.getList("handlers", 8);
                ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(handlers.size());
                for (int j = 0; j < handlers.size(); ++j) {
                    ids.add(ResourceLocation.parse((String)handlers.getString(j)));
                }
                this.exposedHandlers.put(pos, List.copyOf(ids));
            }
        }
        if (tag.contains("no_part_menus", 9)) {
            ListTag noMenu = tag.getList("no_part_menus", 4);
            for (int i = 0; i < noMenu.size(); ++i) {
                BlockPos pos = BlockPos.of((long)((LongTag)noMenu.get(i)).getAsLong());
                this.partMenus.put(pos, null);
            }
        }
    }

    public abstract Component getDisplayName();

    @Nullable
    public final AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        BlockPos target = this.pendingMenuPart;
        this.pendingMenuPart = null;
        if (target != null && this.partMenus.containsKey(target)) {
            GhostPartMenuFactory factory = this.partMenus.get(target);
            if (factory == null) {
                return null;
            }
            PDLAbstractContainerMenu<?> menu = factory.create(this, target, containerId, inventory, player);
            if (menu != null) {
                return menu;
            }
            return null;
        }
        return this.createControllerMenu(containerId, inventory, player);
    }

    protected abstract PDLAbstractContainerMenu<?> createControllerMenu(int var1, Inventory var2, Player var3);
}

