/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.multiblocks;

import com.portingdeadmods.portingdeadlibs.api.blockentities.multiblocks.MultiblockEntity;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockData;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockDefinition;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.portingdeadlibs.api.utils.HorizontalDirection;
import com.portingdeadmods.portingdeadlibs.utils.MultiblockHelper;
import com.portingdeadmods.portingdeadlibs.utils.ranges.IntRange;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.Nullable;

public interface Multiblock {
    public static final BooleanProperty FORMED = BooleanProperty.create((String)"formed");

    public Block getUnformedController();

    public Block getFormedController();

    public MultiblockLayer[] getLayout();

    public MultiblockDefinition getDefinition();

    public BlockEntityType<? extends MultiblockEntity> getMultiBlockEntityType();

    default public List<IntIntPair> getWidths() {
        ArrayList<IntIntPair> widths = new ArrayList<IntIntPair>(this.getMaxSize());
        for (MultiblockLayer layer : this.getLayout()) {
            if (layer.dynamic()) {
                for (int i = 0; i < (Integer)layer.range().getMax(); ++i) {
                    widths.add(layer.getWidths());
                }
                continue;
            }
            widths.add(layer.getWidths());
        }
        return widths;
    }

    @Nullable
    public BlockState formBlock(Level var1, BlockPos var2, BlockPos var3, int var4, int var5, MultiblockData var6, @Nullable Player var7);

    default public BlockState unformBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData multiblockData, @Nullable Player player) {
        int blockId = multiblockData.layers()[layoutIndex].layer()[layerIndex];
        Block block = this.getDefinition().getDefaultBlock(blockId);
        return block != null ? block.defaultBlockState() : null;
    }

    default public void afterFormBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, MultiblockData multiblockData, @Nullable Player player) {
    }

    default public void afterUnformBlock(Level level, BlockPos blockPos, BlockPos controllerPos, int layerIndex, int layoutIndex, HorizontalDirection direction, @Nullable Player player) {
    }

    public boolean isFormed(Level var1, BlockPos var2);

    @Nullable
    default public HorizontalDirection getFixedDirection() {
        return null;
    }

    default public int getMaxSize() {
        int maxSize = 0;
        for (MultiblockLayer layer : this.getLayout()) {
            maxSize += ((Integer)layer.range().getMax()).intValue();
        }
        return maxSize;
    }

    default public MultiblockLayer layer(int ... layer) {
        return new MultiblockLayer(false, IntRange.of(1, 1), layer);
    }

    default public boolean unform(Level level, BlockPos controllerPos) {
        return MultiblockHelper.form(this, controllerPos, level, null);
    }

    default public boolean unform(Level level, BlockPos controllerPos, @Nullable Player player) {
        return MultiblockHelper.form(this, controllerPos, level, player);
    }

    default public boolean form(Level level, BlockPos controllerPos) {
        return MultiblockHelper.form(this, controllerPos, level, null);
    }

    default public boolean form(Level level, BlockPos controllerPos, @Nullable Player player) {
        return MultiblockHelper.form(this, controllerPos, level, player);
    }
}

