/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.api.ghost;

import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockControllerBE;
import com.portingdeadmods.portingdeadlibs.api.ghost.GhostMultiblockShape;
import com.portingdeadmods.portingdeadlibs.api.ghost.SimpleGhostMultiblockPartBE;
import com.portingdeadmods.portingdeadlibs.utils.AABBUtils;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GhostControllerItem
extends BlockItem {
    public GhostControllerItem(Block controllerBlock, Item.Properties properties) {
        super(controllerBlock, properties);
    }

    @NotNull
    protected abstract Block getPartBlock();

    @NotNull
    protected abstract GhostMultiblockShape getBaseShape();

    @NotNull
    protected GhostMultiblockShape getShape(@NotNull BlockPlaceContext context) {
        return this.getBaseShape().getRotated(context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    protected BlockPos getOrigin(@NotNull BlockPlaceContext context) {
        return context.getClickedPos().subtract((Vec3i)this.getShape(context).getControllerPosition());
    }

    @NotNull
    protected AABB getMultiblockBounds(@NotNull BlockPlaceContext context) {
        return this.getShape(context).getRelativeBounds().move(this.getOrigin(context));
    }

    public boolean canPlace(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Level level = context.getLevel();
        AABB bounds = this.getMultiblockBounds(context);
        List<BlockPos> badPos = AABBUtils.getAllPositionsInAABB(bounds).stream().filter(pos -> !level.getBlockState(pos).canBeReplaced()).toList();
        return badPos.isEmpty() && super.canPlace(context, state);
    }

    protected boolean placeBlock(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        BlockPos relativePartPos2;
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return true;
        }
        GhostMultiblockShape shape = this.getShape(context);
        BlockPos origin = this.getOrigin(context);
        BlockPos controllerWorldPos = origin.offset((Vec3i)shape.getControllerPosition());
        HashSet<BlockPos> allRelativePositions = new HashSet<BlockPos>(shape.getPartPositions());
        allRelativePositions.add(shape.getControllerPosition());
        for (BlockPos relativePos : allRelativePositions) {
            BlockPos worldPos = origin.offset((Vec3i)relativePos);
            BlockState blockToPlace = relativePos.equals((Object)shape.getControllerPosition()) ? this.getBlock().defaultBlockState() : this.getPartBlock().defaultBlockState();
            level.setBlockAndUpdate(worldPos, blockToPlace);
        }
        for (BlockPos relativePartPos2 : shape.getPartPositions()) {
            BlockPos worldPartPos = origin.offset((Vec3i)relativePartPos2);
            BlockEntity blockEntity = level.getBlockEntity(worldPartPos);
            if (!(blockEntity instanceof SimpleGhostMultiblockPartBE)) continue;
            SimpleGhostMultiblockPartBE partBE = (SimpleGhostMultiblockPartBE)blockEntity;
            partBE.setControllerPos(controllerWorldPos);
        }
        relativePartPos2 = level.getBlockEntity(controllerWorldPos);
        if (relativePartPos2 instanceof GhostMultiblockControllerBE) {
            GhostMultiblockControllerBE controllerBE = (GhostMultiblockControllerBE)relativePartPos2;
            List<BlockPos> partWorldPositions = shape.getPartPositions().stream().map(arg_0 -> ((BlockPos)origin).offset(arg_0)).collect(Collectors.toList());
            List<BlockPos> itemHandlerPartPositions = shape.getItemHandlerParts().stream().map(arg_0 -> ((BlockPos)origin).offset(arg_0)).collect(Collectors.toList());
            List<BlockPos> fluidHandlerPartPositions = shape.getFluidHandlerParts().stream().map(arg_0 -> ((BlockPos)origin).offset(arg_0)).collect(Collectors.toList());
            List<BlockPos> energyHandlerPartPositions = shape.getEnergyStorageParts().stream().map(arg_0 -> ((BlockPos)origin).offset(arg_0)).collect(Collectors.toList());
            controllerBE.setPartPositions(partWorldPositions, itemHandlerPartPositions, fluidHandlerPartPositions, energyHandlerPartPositions);
        }
        List<BlockPos> allWorldPositions = allRelativePositions.stream().map(arg_0 -> ((BlockPos)origin).offset(arg_0)).collect(Collectors.toList());
        this.afterPlacement(level, controllerWorldPos, allWorldPositions, context.getPlayer());
        return true;
    }

    protected void afterPlacement(@NotNull Level level, @NotNull BlockPos controllerPos, @NotNull List<BlockPos> allPos, @Nullable Player player) {
    }
}

