/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.client.screens.widgets;

import com.portingdeadmods.portingdeadlibs.PortingDeadLibs;
import com.portingdeadmods.portingdeadlibs.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.gui.utils.FluidTankRenderer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidTankWidget
extends AbstractWidget {
    private static final ResourceLocation SMALL_TANK = PortingDeadLibs.rl("small_tank");
    private static final ResourceLocation NORMAL_TANK = PortingDeadLibs.rl("normal_tank");
    private static final ResourceLocation LARGE_TANK = PortingDeadLibs.rl("large_tank");
    private final TankVariants variant;
    private final FluidTankRenderer renderer;
    private final IFluidHandler fluidHandler;

    public FluidTankWidget(int x, int y, TankVariants variant, ContainerBlockEntity entity) {
        this(x, y, variant, entity.getFluidHandler());
    }

    public FluidTankWidget(int x, int y, TankVariants variant, IFluidHandler fluidHandler) {
        super(x, y, variant.textureWidth, variant.textureHeight, CommonComponents.EMPTY);
        this.variant = variant;
        this.renderer = new FluidTankRenderer((long)fluidHandler.getTankCapacity(0), true, this.width - 2, this.height - 2);
        this.fluidHandler = fluidHandler;
    }

    public List<Component> getFluidTooltip() {
        return this.renderer.getTooltip(this.fluidHandler.getFluidInTank(0));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        guiGraphics.blitSprite(this.variant.location, this.getX(), this.getY(), this.width, this.height);
        this.renderer.render(guiGraphics.pose(), this.getX() + 1, this.getY() + 1, this.fluidHandler.getFluidInTank(0));
        if (this.isHovered()) {
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, this.getFluidTooltip(), i, i1);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum TankVariants {
        SMALL(18, 54, SMALL_TANK),
        NORMAL(36, 54, NORMAL_TANK),
        LARGE(54, 54, LARGE_TANK);

        final int textureWidth;
        final int textureHeight;
        final ResourceLocation location;

        private TankVariants(int textureWidth, int textureHeight, ResourceLocation location) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.location = location;
        }
    }
}

