/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import com.portingdeadmods.portingdeadlibs.api.fluids.PDLFluid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class FluidRegistrationHelper {
    private final List<PDLFluid> fluids = new ArrayList<PDLFluid>();
    private final DeferredRegister.Blocks blockRegister;
    private final DeferredRegister.Items itemRegister;
    private final DeferredRegister<FluidType> fluidTypeRegister;
    private final DeferredRegister<Fluid> fluidRegister;
    private boolean createFluidsRegister;

    public FluidRegistrationHelper(DeferredRegister.Blocks blockRegister, DeferredRegister.Items itemRegister, DeferredRegister<FluidType> fluidTypeRegister, DeferredRegister<Fluid> fluidRegister) {
        this.blockRegister = blockRegister;
        this.itemRegister = itemRegister;
        this.fluidTypeRegister = fluidTypeRegister;
        this.fluidRegister = fluidRegister;
    }

    public FluidRegistrationHelper(DeferredRegister.Blocks blockRegister, DeferredRegister.Items itemRegister, String modid) {
        this(blockRegister, itemRegister, (DeferredRegister<FluidType>)DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)modid), (DeferredRegister<Fluid>)DeferredRegister.create((ResourceKey)Registries.FLUID, (String)modid));
        this.createFluidsRegister = true;
    }

    public <T extends PDLFluid> T registerFluid(T fluid) {
        fluid.stillFluid = this.getFluidRegister().register(fluid.getName(), fluid.stillFluid);
        fluid.flowingFluid = this.getFluidRegister().register(FluidRegistrationHelper.flowing(fluid.getName()), fluid.flowingFluid);
        fluid.fluidType = this.getFluidTypeRegister().register(fluid.getName(), fluid.fluidType);
        fluid.block = () -> new LiquidBlock((FlowingFluid)fluid.stillFluid.get(), fluid.blockProperties());
        fluid.block = this.getBlockRegister().register(FluidRegistrationHelper.fluid(fluid.getName()), fluid.block);
        fluid.deferredBucket = this.getItemRegister().register(FluidRegistrationHelper.bucket(fluid.getName()), () -> new BucketItem((Fluid)fluid.stillFluid.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        this.fluids.add(fluid);
        return fluid;
    }

    public DeferredRegister.Blocks getBlockRegister() {
        return this.blockRegister;
    }

    public DeferredRegister.Items getItemRegister() {
        return this.itemRegister;
    }

    public DeferredRegister<FluidType> getFluidTypeRegister() {
        return this.fluidTypeRegister;
    }

    public DeferredRegister<Fluid> getFluidRegister() {
        return this.fluidRegister;
    }

    public List<PDLFluid> getFluids() {
        return this.fluids;
    }

    public void register(IEventBus modEventBus) {
        if (this.createFluidsRegister) {
            this.getFluidRegister().register(modEventBus);
            this.getFluidTypeRegister().register(modEventBus);
        }
    }

    private static String fluid(String fluid) {
        return fluid + "_fluid";
    }

    private static String flowing(String fluid) {
        return fluid + "_flowing";
    }

    private static String bucket(String fluid) {
        return fluid + "_bucket";
    }
}

