/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import com.mojang.datafixers.util.Pair;
import com.portingdeadmods.portingdeadlibs.api.blockentities.multiblocks.FakeBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.blockentities.multiblocks.MultiblockEntity;
import com.portingdeadmods.portingdeadlibs.api.blockentities.multiblocks.SavesControllerPosBlockEntity;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.Multiblock;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockData;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockDefinition;
import com.portingdeadmods.portingdeadlibs.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.portingdeadlibs.api.utils.HorizontalDirection;
import com.portingdeadmods.portingdeadlibs.utils.ranges.IntRange;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanLists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiblockHelper {
    private MultiblockHelper() {
    }

    public static MultiblockData getUnformedMultiblock(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player, boolean sendErrorMsg) {
        MultiblockLayer[] layout = multiblock.getLayout();
        MultiblockLayer[] actualLayout = new MultiblockLayer[multiblock.getMaxSize()];
        MultiblockDefinition def = multiblock.getDefinition();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        List<HorizontalDirection> directions = MultiblockHelper.getHorizontalDirections(multiblock, player);
        int y = 0;
        BooleanArrayList multiblockIndexList = new BooleanArrayList();
        Pair prioritizedDirectionLayout = Pair.of((Object)BooleanLists.emptyList(), (Object)((Object)HorizontalDirection.NORTH));
        HashMap<HorizontalDirection, Pair> firstMissingBlockPoses = new HashMap<HorizontalDirection, Pair>();
        for (HorizontalDirection mDirection : directions) {
            BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(mDirection, controllerPos, relativeControllerPos);
            int actualLayoutSize = 0;
            for (MultiblockLayer layer : layout) {
                if (!layer.dynamic()) {
                    int x = 0;
                    int z = 0;
                    int width = multiblock.getWidths().get(y).leftInt();
                    for (int blockIndex : layer.layer()) {
                        BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, y, z), mDirection);
                        if (def.getDefaultBlock(blockIndex) != null && def.getPredicate(blockIndex).test(level.getBlockState(curBlockPos)) && !multiblock.isFormed(level, curBlockPos) || def.getDefaultBlock(blockIndex) == null) {
                            multiblockIndexList.add(true);
                        } else {
                            firstMissingBlockPoses.putIfAbsent(mDirection, Pair.of((Object)curBlockPos, (Object)blockIndex));
                            multiblockIndexList.add(false);
                        }
                        if (x + 1 < width) {
                            ++x;
                            continue;
                        }
                        x = 0;
                        ++z;
                    }
                    actualLayout[y] = layer;
                    ++actualLayoutSize;
                } else {
                    int minSize = (Integer)layer.range().getMin();
                    int maxSize = (Integer)layer.range().getMax();
                    block3: for (int i = 0; i < maxSize; ++i) {
                        int x = 0;
                        int z = 0;
                        int width = multiblock.getWidths().get(y).leftInt();
                        for (int blockIndex : layer.layer()) {
                            BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, y + i, z), mDirection);
                            if (def.getDefaultBlock(blockIndex) != null && def.getPredicate(blockIndex).test(level.getBlockState(curBlockPos)) && !multiblock.isFormed(level, curBlockPos) || def.getDefaultBlock(blockIndex) == null) {
                                multiblockIndexList.add(true);
                            } else {
                                if (i >= minSize) break block3;
                                firstMissingBlockPoses.putIfAbsent(mDirection, Pair.of((Object)curBlockPos, (Object)blockIndex));
                                multiblockIndexList.add(false);
                            }
                            if (x + 1 < width) {
                                ++x;
                                continue;
                            }
                            x = 0;
                            ++z;
                        }
                        actualLayout[y + i] = new MultiblockLayer(true, IntRange.of(1, 1), layer.layer());
                        ++actualLayoutSize;
                    }
                }
                ++y;
            }
            if (!multiblockIndexList.contains(false)) {
                return new MultiblockData(true, mDirection, Arrays.copyOf(actualLayout, actualLayoutSize));
            }
            for (int i = multiblockIndexList.size() - 1; i >= 0; --i) {
                if (multiblockIndexList.getBoolean(i)) continue;
                multiblockIndexList.removeBoolean(i);
            }
            if (multiblockIndexList.size() > ((BooleanList)prioritizedDirectionLayout.getFirst()).size()) {
                prioritizedDirectionLayout = Pair.of((Object)multiblockIndexList, (Object)((Object)mDirection));
            }
            multiblockIndexList = new BooleanArrayList();
            y = 0;
        }
        HorizontalDirection prioritizedDirection = (HorizontalDirection)((Object)prioritizedDirectionLayout.getSecond());
        if (sendErrorMsg && player != null && !level.isClientSide()) {
            MultiblockHelper.sendFailureMsg(player, level, (BlockPos)((Pair)firstMissingBlockPoses.get((Object)prioritizedDirection)).getFirst(), def, (Integer)((Pair)firstMissingBlockPoses.get((Object)prioritizedDirection)).getSecond());
        }
        return new MultiblockData(false, null, null);
    }

    @NotNull
    private static List<HorizontalDirection> getHorizontalDirections(Multiblock multiblock, @Nullable Player player) {
        List<HorizontalDirection> directions;
        HorizontalDirection direction;
        if (multiblock.getFixedDirection() != null) {
            direction = multiblock.getFixedDirection();
        } else {
            HorizontalDirection horizontalDirection = direction = player != null ? HorizontalDirection.fromRegularDirection(player.getDirection()) : HorizontalDirection.NORTH;
        }
        if (multiblock.getFixedDirection() == null) {
            HorizontalDirection[] values = HorizontalDirection.values();
            directions = List.of(values);
        } else {
            directions = Collections.singletonList(direction);
        }
        return directions;
    }

    public static BlockPos getCurPos(Vec3i firstPos, Vec3i relativePos, HorizontalDirection direction) {
        int firstBlockPosX = firstPos.getX();
        int firstBlockPosY = firstPos.getY();
        int firstBlockPosZ = firstPos.getZ();
        int modZ = relativePos.getZ();
        int y = relativePos.getY();
        int modX = relativePos.getX();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> new BlockPos(firstBlockPosX + modX, firstBlockPosY + y, firstBlockPosZ + modZ);
            case HorizontalDirection.EAST -> new BlockPos(firstBlockPosX - modZ, firstBlockPosY + y, firstBlockPosZ + modX);
            case HorizontalDirection.SOUTH -> new BlockPos(firstBlockPosX - modX, firstBlockPosY + y, firstBlockPosZ - modZ);
            case HorizontalDirection.WEST -> new BlockPos(firstBlockPosX + modZ, firstBlockPosY + y, firstBlockPosZ - modX);
        };
    }

    public static BlockPos getFirstBlockPos(HorizontalDirection direction, BlockPos controllerPos, Vec3i relativeControllerPos) {
        int firstBlockPosX = switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> controllerPos.getX() - relativeControllerPos.getX();
            case HorizontalDirection.EAST -> controllerPos.getX() + relativeControllerPos.getZ();
            case HorizontalDirection.SOUTH -> controllerPos.getX() + relativeControllerPos.getX();
            case HorizontalDirection.WEST -> controllerPos.getX() - relativeControllerPos.getZ();
        };
        int firstBlockPosY = controllerPos.getY() - relativeControllerPos.getY();
        int firstBlockPosZ = switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> controllerPos.getZ() - relativeControllerPos.getZ();
            case HorizontalDirection.EAST -> controllerPos.getZ() - relativeControllerPos.getX();
            case HorizontalDirection.SOUTH -> controllerPos.getZ() + relativeControllerPos.getZ();
            case HorizontalDirection.WEST -> controllerPos.getZ() + relativeControllerPos.getX();
        };
        return new BlockPos(firstBlockPosX, firstBlockPosY, firstBlockPosZ);
    }

    public static Vec3i getRelativeControllerPos(Multiblock multiblock) {
        int controllerIndex = -1;
        for (Map.Entry<Integer, it.unimi.dsi.fastutil.Pair<Predicate<BlockState>, Block>> entry : multiblock.getDefinition().def().entrySet()) {
            if (!((Predicate)entry.getValue().first()).test(multiblock.getUnformedController().defaultBlockState())) continue;
            controllerIndex = entry.getKey();
        }
        MultiblockLayer[] layout = multiblock.getLayout();
        int y = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int z = 0;
            int width = multiblock.getWidths().get(y).leftInt();
            for (int blockIndex : layer.layer()) {
                if (blockIndex == controllerIndex) {
                    return new Vec3i(x, y, z);
                }
                if (x + 1 < width) {
                    ++x;
                    continue;
                }
                x = 0;
                ++z;
            }
            ++y;
        }
        throw new IllegalStateException("Multiblock pre checks failed, controller not found");
    }

    private static void sendFailureMsg(Player player, Level level, BlockPos curBlockPos, MultiblockDefinition def, int blockIndex) {
        player.sendSystemMessage((Component)Component.translatable((String)"multiblock.info.failed_to_construct").withStyle(ChatFormatting.RED).append(":"));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.actual_block", (Object[])new Object[]{level.getBlockState(curBlockPos).getBlock().getName().getString()}).withStyle(ChatFormatting.DARK_GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.expected_block", (Object[])new Object[]{def.getDefaultBlock(blockIndex).getName().getString()}).withStyle(ChatFormatting.DARK_GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.block_pos", (Object[])new Object[]{curBlockPos.getX(), curBlockPos.getY(), curBlockPos.getZ()}).withStyle(ChatFormatting.DARK_GRAY)));
    }

    public static boolean form(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        MultiblockData multiblockData = MultiblockHelper.getUnformedMultiblock(multiblock, controllerPos, level, player, true);
        HorizontalDirection direction = multiblockData.direction();
        if (multiblock.getFixedDirection() != null) {
            direction = multiblock.getFixedDirection();
        }
        if (multiblockData.valid() && direction != null) {
            MultiblockHelper.formBlocks(multiblock, multiblockData, controllerPos, level, player);
            return true;
        }
        return false;
    }

    public static boolean form(Multiblock multiblock, BlockPos controllerPos, Level level) {
        return MultiblockHelper.form(multiblock, controllerPos, level, null);
    }

    private static void formBlocks(Multiblock multiblock, MultiblockData multiblockData, BlockPos controllerPos, Level level, @Nullable Player player) {
        HorizontalDirection direction = multiblockData.direction();
        MultiblockLayer[] layout = multiblockData.layers();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(direction, controllerPos, relativeControllerPos);
        MultiblockDefinition def = multiblock.getDefinition();
        int index = 0;
        int yIndex = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int width = multiblock.getWidths().get(yIndex).leftInt();
            int z = 0;
            for (int blockIndex : layer.layer()) {
                BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, yIndex, z), direction);
                if (def.getDefaultBlock(blockIndex) != null) {
                    BlockState oldState = level.getBlockState(curBlockPos);
                    BlockState newState = multiblock.formBlock(level, curBlockPos, controllerPos, index, yIndex, multiblockData, player);
                    if (newState != null) {
                        level.setBlockAndUpdate(curBlockPos, newState);
                        level.invalidateCapabilities(curBlockPos);
                        level.sendBlockUpdated(curBlockPos, oldState, newState, 13);
                    }
                    multiblock.afterFormBlock(level, curBlockPos, controllerPos, index, yIndex, multiblockData, player);
                    BlockEntity blockEntity = level.getBlockEntity(curBlockPos);
                    if (blockEntity instanceof SavesControllerPosBlockEntity) {
                        SavesControllerPosBlockEntity savesControllerPosBE = (SavesControllerPosBlockEntity)blockEntity;
                        savesControllerPosBE.setControllerPos(controllerPos);
                    }
                    if (blockEntity instanceof FakeBlockEntity) {
                        FakeBlockEntity fakeBE = (FakeBlockEntity)blockEntity;
                        blockEntity = level.getBlockEntity(fakeBE.getActualBlockEntityPos());
                    }
                    if (blockEntity instanceof MultiblockEntity) {
                        MultiblockEntity entity = (MultiblockEntity)blockEntity;
                        entity.setMultiblockData(multiblockData);
                    }
                }
                if (x + 1 < width) {
                    ++x;
                } else {
                    x = 0;
                    ++z;
                }
                ++index;
            }
            index = 0;
            ++yIndex;
        }
    }

    public static boolean unform(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        MultiblockHelper.unformBlocks(multiblock, controllerPos, level, player);
        return true;
    }

    public static boolean unform(Multiblock multiblock, BlockPos controllerPos, Level level) {
        return MultiblockHelper.unform(multiblock, controllerPos, level, null);
    }

    private static void unformBlocks(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        BlockPos controllerPos1 = controllerPos;
        BlockEntity blockEntity = level.getBlockEntity(controllerPos1);
        if (blockEntity instanceof FakeBlockEntity) {
            FakeBlockEntity fakeBE = (FakeBlockEntity)blockEntity;
            controllerPos1 = fakeBE.getActualBlockEntityPos();
        }
        if (!((blockEntity = level.getBlockEntity(controllerPos1)) instanceof MultiblockEntity)) {
            throw new IllegalStateException(String.valueOf(multiblock) + " multiblock controller does not have a blockentity");
        }
        MultiblockEntity multiblockEntity = (MultiblockEntity)blockEntity;
        MultiblockData data = multiblockEntity.getMultiblockData();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        HorizontalDirection direction = data.direction();
        BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(direction, controllerPos, relativeControllerPos);
        MultiblockLayer[] layout = data.layers();
        int yIndex = 0;
        int xIndex = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int width = multiblock.getWidths().get(yIndex).leftInt();
            int z = 0;
            for (int blockIndex : layer.layer()) {
                BlockState expectedState;
                BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, yIndex, z), direction);
                BlockState unformedBlock = multiblock.unformBlock(level, curBlockPos, controllerPos, xIndex, yIndex, data, player);
                BlockState blockState = level.getBlockState(curBlockPos);
                if (!level.getBlockState(curBlockPos).isEmpty() && (expectedState = multiblock.formBlock(level, curBlockPos, controllerPos, xIndex, yIndex, data, player)) != null && blockState.is(expectedState.getBlock()) && multiblock.isFormed(level, curBlockPos)) {
                    level.setBlockAndUpdate(curBlockPos, unformedBlock);
                    level.invalidateCapabilities(curBlockPos);
                    level.sendBlockUpdated(curBlockPos, blockState, unformedBlock, 13);
                    multiblock.afterUnformBlock(level, curBlockPos, controllerPos, xIndex, yIndex, direction, player);
                }
                if (x + 1 < width) {
                    ++x;
                } else {
                    x = 0;
                    ++z;
                }
                ++xIndex;
            }
            xIndex = 0;
            ++yIndex;
        }
    }
}

