/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils;

import javax.annotation.Nullable;

public sealed interface Result<T, E> {
    @Nullable
    default public E error() {
        return null;
    }

    public static <T, E extends Exception> Result<T, E> ok(T val) {
        return new Ok(val);
    }

    public static <T, E extends Exception> Result<T, E> err(E exception) {
        return new Err(exception);
    }

    public static <T> Result<T, Exception> err(String message) {
        return new Err(new Exception(message));
    }

    public record Ok<T, E>(T value) implements Result<T, E>
    {
    }

    public record Err<T, E>(E error) implements Result<T, E>
    {
    }
}

