/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.portingdeadlibs.utils.parsing;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class GradientUtils {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("&([lonmk])|&#([0-9A-Fa-f]{6})");

    public static Component parseFormatting(String input) {
        MutableComponent result = Component.empty();
        Matcher matcher = FORMAT_PATTERN.matcher(input);
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderline = false;
        boolean isStrikethrough = false;
        Color currentColor = null;
        StringBuilder currentText = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String text;
            if (matcher.start() > lastEnd && !(text = input.substring(lastEnd, matcher.start())).isEmpty()) {
                currentText.append(text);
            }
            String formatCode = matcher.group(1);
            String colorCode = matcher.group(2);
            if (formatCode != null) {
                switch (formatCode) {
                    case "l": {
                        isBold = true;
                        break;
                    }
                    case "o": {
                        isItalic = true;
                        break;
                    }
                    case "n": {
                        isUnderline = true;
                        break;
                    }
                    case "m": {
                        isStrikethrough = true;
                        break;
                    }
                }
            } else if (colorCode != null) {
                if (currentText.length() > 0) {
                    boolean finalIsBold = isBold;
                    boolean finalIsItalic = isItalic;
                    boolean finalIsUnderline = isUnderline;
                    boolean finalIsStrikethrough = isStrikethrough;
                    Color finalCurrentColor = currentColor;
                    result.append((Component)Component.literal((String)currentText.toString()).withStyle(style -> style.withBold(Boolean.valueOf(finalIsBold)).withItalic(Boolean.valueOf(finalIsItalic)).withUnderlined(Boolean.valueOf(finalIsUnderline)).withStrikethrough(Boolean.valueOf(finalIsStrikethrough)).withColor(finalCurrentColor != null ? TextColor.fromRgb((int)finalCurrentColor.getRGB()) : null)));
                    currentText.setLength(0);
                }
                currentColor = Color.decode("#" + colorCode);
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < input.length() || currentText.length() > 0) {
            currentText.append(input.substring(lastEnd));
            boolean finalIsBold1 = isBold;
            boolean finalIsItalic1 = isItalic;
            boolean finalIsUnderline1 = isUnderline;
            boolean finalIsStrikethrough1 = isStrikethrough;
            Color finalCurrentColor1 = currentColor;
            result.append((Component)Component.literal((String)currentText.toString()).withStyle(style -> style.withBold(Boolean.valueOf(finalIsBold1)).withItalic(Boolean.valueOf(finalIsItalic1)).withUnderlined(Boolean.valueOf(finalIsUnderline1)).withStrikethrough(Boolean.valueOf(finalIsStrikethrough1)).withColor(finalCurrentColor1 != null ? TextColor.fromRgb((int)finalCurrentColor1.getRGB()) : null)));
        }
        return result;
    }
}

