/*
 * Decompiled with CFR 0.152.
 */
package hatterangs;

import hatterangs.EntityAnimation;
import hatterangs.Vector;
import net.mcreator.freddyfazbear.entity.FazerangEntity;
import net.mcreator.freddyfazbear.init.FazcraftModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FazerangAnimation
extends EntityAnimation {
    private static final int MAX_LIFETIME = 20;
    private static final float MAX_RANGE = 5.0f;
    FazerangEntity entity;
    ItemStack item;
    Player owner;
    Vector startPos;
    Vector currentPos;
    Vector currentDir;
    int lifeTime = 0;
    boolean backwards;
    boolean thrown;

    public FazerangAnimation(FazerangEntity entity, Vector pos, Vector dir) {
        this.entity = entity;
        this.owner = entity.getOwner();
        this.item = entity.getItem();
        this.thrown = true;
        this.startPos = pos.clone();
        this.currentPos = pos.clone();
        this.currentDir = dir.clone();
    }

    @Override
    public void tick() {
        if (!this.thrown) {
            return;
        }
        if (this.entity == null) {
            return;
        }
        if (this.entity.isDeadOrDying()) {
            return;
        }
        if (this.owner == null) {
            return;
        }
        Vector dir = this.currentDir.clone();
        Vector startPos = this.startPos.clone();
        if ((double)this.lifeTime > 15.384615384615383) {
            Vector entityPos;
            Vector playerPos = new Vector(this.owner.position().add(0.0, 1.0, 0.0));
            if (playerPos.distance(entityPos = new Vector(this.entity.position())) < 1.4) {
                this.destroyEntity();
                return;
            }
            this.entity.setNoGravity(true);
            Vec3 vec3 = this.owner.position().subtract(this.entity.position());
            Vec3 vec31 = vec3.normalize().scale(0.8);
            this.entity.setPos(this.entity.getX() + vec31.x, this.entity.getY() + vec31.y + 0.5, this.entity.getZ() + vec31.z);
            float deltaTime = 0.05f;
            float rotation = this.mapf(deltaTime, 0.0f, 1.0f, 0.0f, -720.0f);
            this.entity.setYRot((this.entity.getYRot() + rotation) % 360.0f);
            this.hitDetection();
            return;
        }
        float deltaTime = (float)this.lifeTime / 20.0f;
        float remappedTime = (float)Math.toRadians(this.mapf(deltaTime, 0.0f, 1.0f, 0.0f, 195.0f));
        float rotation = this.mapf(deltaTime, 0.0f, 1.0f, 0.0f, -720.0f);
        float multiplier = (float)Math.sin(remappedTime);
        float remapped = this.mapf(multiplier, -1.0f, 1.0f, -0.2f, 5.0f);
        this.currentPos = startPos.clone().add(dir.clone().multiply(remapped));
        this.entity.setPos(this.currentPos.getX(), this.currentPos.getY(), this.currentPos.getZ());
        this.entity.setYRot(rotation);
        this.hitDetection();
        this.detectBlockHit();
        ++this.lifeTime;
    }

    public void hitDetection() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.isDeadOrDying()) {
            return;
        }
        if (this.entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        for (Entity hit : this.entity.getCommandSenderWorld().getEntities((Entity)this.entity, this.entity.getBoundingBox().inflate(0.2, 2.0, 0.2), e -> e instanceof LivingEntity)) {
            LivingEntity livingEntity;
            if (hit == this.entity || hit == this.owner || !(hit instanceof LivingEntity) || !(livingEntity = (LivingEntity)hit).hurt(this.owner.damageSources().playerAttack(this.owner), 4.0f) || !(this.owner instanceof Player) || this.owner.getAbilities().instabuild || this.item == null) continue;
            this.item.hurtAndBreak(1, (LivingEntity)this.owner, null);
            if (this.item.getDamageValue() < this.item.getMaxDamage()) continue;
            this.item.shrink(1);
            this.item.setDamageValue(0);
        }
    }

    public void detectBlockHit() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.isDeadOrDying()) {
            return;
        }
        if (this.entity.getCommandSenderWorld().isClientSide) {
            return;
        }
        if (this.entity.getCommandSenderWorld().getBlockState(this.entity.blockPosition()).isSolidRender((BlockGetter)this.entity.getCommandSenderWorld(), this.entity.blockPosition())) {
            this.lifeTime = 20;
        }
    }

    public void destroyEntity() {
        if (this.entity != null) {
            if (this.owner != null) {
                this.owner.getCooldowns().removeCooldown((Item)FazcraftModItems.HATTERANG.get());
                this.owner.getCooldowns().addCooldown((Item)FazcraftModItems.HATTERANG.get(), 45);
            }
            this.entity.remove(Entity.RemovalReason.KILLED);
            this.entity = null;
        }
        this.backwards = false;
        this.thrown = false;
        this.currentPos = null;
        this.currentDir = null;
        this.lifeTime = 0;
    }

    @Override
    public void reset() {
    }

    float mapf(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    float bezierCurve(float t) {
        return t * t * (3.0f - 2.0f * t);
    }
}

