/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.freddyfazbear.init.FazcraftModBlocks;
import net.mcreator.freddyfazbear.init.FazcraftModItems;
import net.mcreator.freddyfazbear.procedures.CleanOVacCleanPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.CleanOVacIdlePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.CleanOVacOffPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.CleanOVacOnEntityTickUpdateProcedure;
import net.mcreator.freddyfazbear.procedures.CleanOVacPetPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.CleanOVacRightClickedOnEntityProcedure;
import net.mcreator.freddyfazbear.procedures.StatueEntityDiesProcedure;
import net.mcreator.freddyfazbear.procedures.StatueEntityIsHurtProcedure;
import net.mcreator.freddyfazbear.procedures.StatueOnInitialEntitySpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class CleanOVacEntity
extends PathfinderMob {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public CleanOVacEntity(EntityType<CleanOVacEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal(this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{((Block)FazcraftModBlocks.TRASH_BAG.get()).asItem()}), false){

            public boolean canUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canContinueToUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new TemptGoal(this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{((Block)FazcraftModBlocks.TRASH.get()).asItem()}), false){

            public boolean canUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canContinueToUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canContinueToUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.5f){

            public boolean canUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canContinueToUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CleanOVacEntity.this.getX();
                double y = CleanOVacEntity.this.getY();
                double z = CleanOVacEntity.this.getZ();
                CleanOVacEntity entity = CleanOVacEntity.this;
                Level world = CleanOVacEntity.this.level();
                return super.canContinueToUse() && CleanOVacIdlePlaybackConditionProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)FazcraftModItems.CLEAN_O_VAC_ITEM.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.cleanovac.idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.cleanovac.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.cleanovac.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CleanOVacEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        StatueEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        StatueEntityDiesProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        StatueOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        CleanOVacEntity entity = this;
        Level world = this.level();
        CleanOVacRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(CleanOVacOffPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CleanOVacPetPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CleanOVacCleanPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(CleanOVacIdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CleanOVacOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CleanOVacEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.15);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }
}

