/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import javax.annotation.Nullable;
import net.mcreator.freddyfazbear.init.FazcraftModItems;
import net.mcreator.freddyfazbear.procedures.DigityperButtonsPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.DigityperOnEntityTickUpdateProcedure;
import net.mcreator.freddyfazbear.procedures.DigityperStancePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.DigityperWavePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.StatueEntityDiesProcedure;
import net.mcreator.freddyfazbear.procedures.StatueEntityIsHurtProcedure;
import net.mcreator.freddyfazbear.procedures.StatueOnInitialEntitySpawnProcedure;
import net.mcreator.freddyfazbear.procedures.StatueRightClickedOnEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class DigityperEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> DATA_digityper_animation = SynchedEntityData.defineId(DigityperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_digityper_wave_playing = SynchedEntityData.defineId(DigityperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_digityper_wave = SynchedEntityData.defineId(DigityperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public DigityperEntity(EntityType<DigityperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (DigityperEntity.this.isInWater()) {
                    DigityperEntity.this.setDeltaMovement(DigityperEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !DigityperEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - DigityperEntity.this.getX();
                    double dy = this.wantedY - DigityperEntity.this.getY();
                    double dz = this.wantedZ - DigityperEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * DigityperEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    DigityperEntity.this.setYRot(this.rotlerp(DigityperEntity.this.getYRot(), f, 10.0f));
                    DigityperEntity.this.yBodyRot = DigityperEntity.this.getYRot();
                    DigityperEntity.this.yHeadRot = DigityperEntity.this.getYRot();
                    if (DigityperEntity.this.isInWater()) {
                        DigityperEntity.this.setSpeed((float)DigityperEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        DigityperEntity.this.setXRot(this.rotlerp(DigityperEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(DigityperEntity.this.getXRot() * ((float)Math.PI / 180)));
                        DigityperEntity.this.setZza(f3 * f1);
                        DigityperEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        DigityperEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    DigityperEntity.this.setSpeed(0.0f);
                    DigityperEntity.this.setYya(0.0f);
                    DigityperEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_digityper_animation, (Object)0);
        builder.define(DATA_digityper_wave_playing, (Object)66);
        builder.define(DATA_digityper_wave, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)FazcraftModItems.DIGITYPER_PLUSHSUIT.get()));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.metal.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.metal.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DigityperEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        StatueEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity, sourceentity);
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        StatueEntityDiesProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        StatueOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datadigityper_animation", ((Integer)this.entityData.get(DATA_digityper_animation)).intValue());
        compound.putInt("Datadigityper_wave_playing", ((Integer)this.entityData.get(DATA_digityper_wave_playing)).intValue());
        compound.putBoolean("Datadigityper_wave", ((Boolean)this.entityData.get(DATA_digityper_wave)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datadigityper_animation")) {
            this.entityData.set(DATA_digityper_animation, (Object)compound.getInt("Datadigityper_animation"));
        }
        if (compound.contains("Datadigityper_wave_playing")) {
            this.entityData.set(DATA_digityper_wave_playing, (Object)compound.getInt("Datadigityper_wave_playing"));
        }
        if (compound.contains("Datadigityper_wave")) {
            this.entityData.set(DATA_digityper_wave, (Object)compound.getBoolean("Datadigityper_wave"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        DigityperEntity entity = this;
        Level world = this.level();
        StatueRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(DigityperButtonsPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(DigityperWavePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(DigityperStancePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        DigityperOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DigityperEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DigityperEntity entity = this;
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 999.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.0);
        return builder;
    }
}

