/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import hatterangs.FazerangAnimation;
import hatterangs.Vector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FazerangEntity
extends Monster {
    Player owner;
    ItemStack item;
    FazerangAnimation animation;

    public FazerangEntity(EntityType<FazerangEntity> type, Level world) {
        super(type, world);
        this.setInvulnerable(true);
        this.setNoGravity(true);
    }

    public void tick() {
        super.tick();
        if (this.animation != null) {
            this.animation.tick();
        } else if (this.owner != null) {
            Vec3 dir = this.owner.getLookAngle();
            this.animation = new FazerangAnimation(this, new Vector(this.position()), new Vector(dir));
        }
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public Player getOwner() {
        return this.owner;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }
}

