/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import javax.annotation.Nullable;
import net.mcreator.freddyfazbear.procedures.AnimatronicLookingTriggerProcedure;
import net.mcreator.freddyfazbear.procedures.AnimatronicStunPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.StunnedConProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyDiesProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyIdlePlaybackProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyOnEntityTickUpdateProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyOnInitialEntitySpawnProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyPounceChargePlaybackProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyPouncePlaybackProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyPounceRecoverPlaybackProcedure;
import net.mcreator.freddyfazbear.procedures.WitheredFoxyWalkPlaybackConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class WitheredFoxyEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_pounceCooldown = SynchedEntityData.defineId(WitheredFoxyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_animation = SynchedEntityData.defineId(WitheredFoxyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_pounceAnimation = SynchedEntityData.defineId(WitheredFoxyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public WitheredFoxyEntity(EntityType<WitheredFoxyEntity> type, Level world) {
        super(type, world);
        this.xpReward = 8;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_pounceCooldown, (Object)90);
        builder.define(DATA_animation, (Object)0);
        builder.define(DATA_pounceAnimation, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 2.25 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canUse() && StunnedConProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canContinueToUse() && StunnedConProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canUse() && StunnedConProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canContinueToUse() && StunnedConProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canUse() && StunnedConProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canContinueToUse() && StunnedConProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canUse() && AnimatronicLookingTriggerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canContinueToUse() && AnimatronicLookingTriggerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canUse() && StunnedConProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WitheredFoxyEntity.this.getX();
                double y = WitheredFoxyEntity.this.getY();
                double z = WitheredFoxyEntity.this.getZ();
                WitheredFoxyEntity entity = WitheredFoxyEntity.this;
                Level world = WitheredFoxyEntity.this.level();
                return super.canContinueToUse() && StunnedConProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.witheredfoxy.idle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:endo02steps")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.witheredfoxy.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:entity.witheredfoxy.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        WitheredFoxyDiesProcedure.execute(source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        WitheredFoxyOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DatapounceCooldown", ((Integer)this.entityData.get(DATA_pounceCooldown)).intValue());
        compound.putInt("Dataanimation", ((Integer)this.entityData.get(DATA_animation)).intValue());
        compound.putInt("DatapounceAnimation", ((Integer)this.entityData.get(DATA_pounceAnimation)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DatapounceCooldown")) {
            this.entityData.set(DATA_pounceCooldown, (Object)compound.getInt("DatapounceCooldown"));
        }
        if (compound.contains("Dataanimation")) {
            this.entityData.set(DATA_animation, (Object)compound.getInt("Dataanimation"));
        }
        if (compound.contains("DatapounceAnimation")) {
            this.entityData.set(DATA_pounceAnimation, (Object)compound.getInt("DatapounceAnimation"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(AnimatronicStunPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(WitheredFoxyIdlePlaybackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(WitheredFoxyPounceRecoverPlaybackProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(WitheredFoxyPounceChargePlaybackProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(WitheredFoxyWalkPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(WitheredFoxyPouncePlaybackProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        WitheredFoxyOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 1.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.2);
        return builder;
    }
}

