/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.mcreator.freddyfazbear.entity.FazerangEntity;
import net.mcreator.freddyfazbear.init.FazcraftModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HatterangItem
extends Item {
    public HatterangItem() {
        super(new Item.Properties().durability(250).rarity(Rarity.EPIC));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.getCooldowns().addCooldown((Item)this, 2500);
            Vec3 look = player.getLookAngle();
            Vec3 pos = player.getEyePosition();
            pos = pos.add(look.x * 0.2, look.y * 0.2, look.z * 0.2);
            pos = pos.add(0.0, -0.5, 0.0);
            double x = pos.x;
            double y = pos.y;
            double z = pos.z;
            float yRot = player.getYRot();
            float xRot = player.getXRot();
            FazerangEntity fazerangEntity = new FazerangEntity((EntityType<FazerangEntity>)((EntityType)FazcraftModEntities.FAZERANG.get()), level);
            fazerangEntity.setItem(player.getItemInHand(hand));
            fazerangEntity.setOwner(player);
            fazerangEntity.moveTo(x, y, z, yRot, xRot);
            level.addFreshEntity((Entity)fazerangEntity);
            if (!level.isClientSide()) {
                level.playSound(null, BlockPos.containing((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5)), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:hatterangthrow")), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.use(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.fazcraft.hatterang.description_0"));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        ImmutableSet e = ImmutableSet.of((Object)Enchantments.SHARPNESS, (Object)Enchantments.MENDING, (Object)Enchantments.LOOTING, (Object)Enchantments.FIRE_ASPECT, (Object)Enchantments.UNBREAKING, (Object)Enchantments.KNOCKBACK, (Object[])new ResourceKey[]{Enchantments.BANE_OF_ARTHROPODS, Enchantments.SMITE});
        return e.contains(enchantment);
    }
}

