/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.procedures;

import javax.annotation.Nullable;
import net.mcreator.freddyfazbear.init.FazcraftModBlocks;
import net.mcreator.freddyfazbear.init.FazcraftModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class LockedBlockOnDestructionProcedure {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LockedBlockOnDestructionProcedure.execute((Event)event, event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), event.getState(), (Entity)event.getPlayer());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, BlockState blockstate, Entity entity) {
        LockedBlockOnDestructionProcedure.execute(null, world, x, y, z, blockstate, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, BlockState blockstate, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!world.isClientSide()) {
            if (blockstate.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"fazcraft:lockable_blocks"))) && LockedBlockOnDestructionProcedure.getBlockNBTLogic(world, BlockPos.containing((double)x, (double)y, (double)z), "locked") && !LockedBlockOnDestructionProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "owner").equals(entity.getStringUUID()) && LockedBlockOnDestructionProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
                ItemStack itemStack;
                Player _player;
                if (event instanceof ICancellableEvent) {
                    ICancellableEvent _cancellable = (ICancellableEvent)event;
                    _cancellable.setCanceled(true);
                }
                if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                    _player.displayClientMessage((Component)Component.literal((String)"You are not the owner of this block!"), true);
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entity;
                    itemStack = _livEnt.getMainHandItem();
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                if (itemStack.isDamageableItem() && world instanceof ServerLevel) {
                    ItemStack itemStack2;
                    ServerLevel _level = (ServerLevel)world;
                    if (entity instanceof LivingEntity) {
                        LivingEntity _livEnt = (LivingEntity)entity;
                        itemStack2 = _livEnt.getMainHandItem();
                    } else {
                        itemStack2 = ItemStack.EMPTY;
                    }
                    itemStack2.hurtAndBreak(-1, _level, null, _stkprov -> {});
                }
            } else if (blockstate.getBlock() == FazcraftModBlocks.CRASH_DOOR_TILE.get() && (LockedBlockOnDestructionProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "doorType").equals("") || LockedBlockOnDestructionProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "doorType").equals("top") || LockedBlockOnDestructionProcedure.getBlockNBTString(world, BlockPos.containing((double)x, (double)y, (double)z), "doorType").equals("1x1")) && LockedBlockOnDestructionProcedure.getEntityGameType(entity) != GameType.CREATIVE && world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 0.5, z + 0.5, new ItemStack((ItemLike)FazcraftModItems.CRASH_DOOR.get()));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
        }
    }

    private static boolean getBlockNBTLogic(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getBoolean(tag);
        }
        return false;
    }

    private static String getBlockNBTString(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getString(tag);
        }
        return "";
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

