/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import net.mcreator.freddyfazbear.procedures.CupcakeNearToyChicaProcedure;
import net.mcreator.freddyfazbear.procedures.ToyBonnieAttackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaDiesProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaHostileIdlePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaHostileStunPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaHostileWalkPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaIdlePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaStunPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyChicaWalkPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.WearingMaskProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ToyChicaEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_hostile = SynchedEntityData.defineId(ToyChicaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public ToyChicaEntity(EntityType<ToyChicaEntity> type, Level world) {
        super(type, world);
        this.xpReward = 9;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_hostile, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 2.25 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = ToyChicaEntity.this.getX();
                double y = ToyChicaEntity.this.getY();
                double z = ToyChicaEntity.this.getZ();
                ToyChicaEntity entity = ToyChicaEntity.this;
                Level world = ToyChicaEntity.this.level();
                return super.canUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ToyChicaEntity.this.getX();
                double y = ToyChicaEntity.this.getY();
                double z = ToyChicaEntity.this.getZ();
                ToyChicaEntity entity = ToyChicaEntity.this;
                Level world = ToyChicaEntity.this.level();
                return super.canContinueToUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = ToyChicaEntity.this.getX();
                double y = ToyChicaEntity.this.getY();
                double z = ToyChicaEntity.this.getZ();
                ToyChicaEntity entity = ToyChicaEntity.this;
                Level world = ToyChicaEntity.this.level();
                return super.canUse() && ToyBonnieAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ToyChicaEntity.this.getX();
                double y = ToyChicaEntity.this.getY();
                double z = ToyChicaEntity.this.getZ();
                ToyChicaEntity entity = ToyChicaEntity.this;
                Level world = ToyChicaEntity.this.level();
                return super.canContinueToUse() && ToyBonnieAttackConditionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:toycidle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:toycsteps")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:toychurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:toycdeath"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        ToyChicaDiesProcedure.execute((Entity)this, source.getEntity());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datahostile", ((Boolean)this.entityData.get(DATA_hostile)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahostile")) {
            this.entityData.set(DATA_hostile, (Object)compound.getBoolean("Datahostile"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(ToyChicaStunPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(ToyChicaHostileStunPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(ToyChicaIdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(ToyChicaHostileIdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(ToyChicaWalkPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(ToyChicaHostileWalkPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CupcakeNearToyChicaProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 70.0);
        builder = builder.add(Attributes.ARMOR, 7.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.3);
        return builder;
    }
}

