/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.entity;

import net.mcreator.freddyfazbear.procedures.AnimatronicStunPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyBonnieIdlePlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyBonnieWalkPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyCupcakeFallPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyCupcakeJumpPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyCupcakeLandPlaybackConditionProcedure;
import net.mcreator.freddyfazbear.procedures.ToyCupcakeOnEntityTickUpdateProcedure;
import net.mcreator.freddyfazbear.procedures.WearingMaskProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ToyCupcakeEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_jumpState = SynchedEntityData.defineId(ToyCupcakeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public ToyCupcakeEntity(EntityType<ToyCupcakeEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_jumpState, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.6f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canContinueToUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canContinueToUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = ToyCupcakeEntity.this.getX();
                double y = ToyCupcakeEntity.this.getY();
                double z = ToyCupcakeEntity.this.getZ();
                ToyCupcakeEntity entity = ToyCupcakeEntity.this;
                Level world = ToyCupcakeEntity.this.level();
                return super.canContinueToUse() && WearingMaskProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
            }
        });
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"fazcraft:toyccupcakedeath"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DatajumpState", ((Integer)this.entityData.get(DATA_jumpState)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DatajumpState")) {
            this.entityData.set(DATA_jumpState, (Object)compound.getInt("DatajumpState"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(AnimatronicStunPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(ToyBonnieIdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(ToyBonnieWalkPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(ToyCupcakeJumpPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(ToyCupcakeFallPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(ToyCupcakeLandPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        ToyCupcakeOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 35.0);
        builder = builder.add(Attributes.ARMOR, 1.5);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.1);
        return builder;
    }
}

