/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.procedures;

import javax.annotation.Nullable;
import net.mcreator.freddyfazbear.init.FazcraftModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class TomatoSeedGETProcedure {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        TomatoSeedGETProcedure.execute((Event)event, event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), event.getState(), (Entity)event.getPlayer());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, BlockState blockstate, Entity entity) {
        TomatoSeedGETProcedure.execute(null, world, x, y, z, blockstate, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, BlockState blockstate, Entity entity) {
        if (entity == null) {
            return;
        }
        double dropChance = 0.0;
        double cornDropChance = 0.0;
        if ((blockstate.getBlock() == Blocks.SHORT_GRASS || blockstate.getBlock() == Blocks.TALL_GRASS) && TomatoSeedGETProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
            ItemEntity entityToSpawn;
            ServerLevel _level;
            dropChance = Math.random();
            cornDropChance = Math.random();
            if (dropChance <= 0.125 && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 0.5, z + 0.5, new ItemStack((ItemLike)FazcraftModItems.TOMATO_SEEDS.get()));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
            if (cornDropChance <= 0.125 && world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 0.5, z + 0.5, new ItemStack((ItemLike)FazcraftModItems.CORN_KERNELS.get()));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

