/*
 * Decompiled with CFR 0.152.
 */
package datadiver;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PermissionUpgradeButton
extends Button {
    public static final ResourceLocation TEXT = ResourceLocation.parse((String)"fazcraft:textures/screens/minigame_datadiver_button.png");
    public static final ResourceLocation HOVERED = ResourceLocation.parse((String)"fazcraft:textures/screens/minigame_datadiver_button_pressed.png");
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    protected final WidgetSprites sprites;

    public PermissionUpgradeButton(int x, int y, Component message, WidgetSprites widgetSprites, Button.OnPress onPress) {
        super(x, y, 200, 20, message, onPress, DEFAULT_NARRATION);
        this.sprites = widgetSprites;
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        boolean hovered = this.isMouseOver(mouseX, mouseY);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation resourcelocation = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        int yOffset = this.isHoveredOrFocused() ? 20 : 0;
        graphics.blit(resourcelocation, this.getX(), this.getY(), 0.0f, (float)yOffset, this.width, this.height, 200, 40);
        int color = hovered ? 0x228B22 : 0x404040;
        graphics.drawCenteredString(mc.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
    }
}

