/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.block;

import java.util.Collections;
import java.util.List;
import net.mcreator.freddyfazbear.procedures.TableBlockAddedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends Block {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)9);

    public TableBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)LEVEL)) {
            default -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)3.0), TableBlock.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)});
            case 0 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)3.0), TableBlock.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)});
            case 1 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0)});
            case 2 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)3.0), TableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)});
            case 3 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), TableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)});
            case 4 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)3.0), TableBlock.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0)});
            case 5 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)3.0));
            case 6 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TableBlock.box((double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0));
            case 7 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0));
            case 8 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TableBlock.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0));
            case 9 -> Shapes.or((VoxelShape)TableBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        };
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        TableBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        TableBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

