/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.block;

import java.util.List;
import net.mcreator.freddyfazbear.block.entity.VentDoorBlockEntity;
import net.mcreator.freddyfazbear.procedures.VentDoorBlockOnBlockRightClickedProcedure;
import net.mcreator.freddyfazbear.procedures.VentDoorRedstoneOffProcedure;
import net.mcreator.freddyfazbear.procedures.VentDoorRedstoneOnProcedure;
import net.mcreator.freddyfazbear.procedures.VentDoorUpdateTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VentDoorBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public VentDoorBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(0.6f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.fazcraft.vent_door.description_0"));
        list.add((Component)Component.translatable((String)"block.fazcraft.vent_door.description_1"));
        list.add((Component)Component.translatable((String)"block.fazcraft.vent_door.description_2"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)VentDoorBlock.box((double)0.01, (double)0.01, (double)12.01, (double)15.99, (double)15.99, (double)13.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)VentDoorBlock.box((double)0.01, (double)0.01, (double)2.01, (double)15.99, (double)15.99, (double)3.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)VentDoorBlock.box((double)12.01, (double)0.01, (double)0.01, (double)13.99, (double)15.99, (double)15.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)VentDoorBlock.box((double)2.01, (double)0.01, (double)0.01, (double)3.99, (double)15.99, (double)15.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)VentDoorBlock.box((double)0.01, (double)12.01, (double)12.01, (double)15.99, (double)15.99, (double)13.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)VentDoorBlock.box((double)0.01, (double)12.01, (double)2.01, (double)15.99, (double)15.99, (double)3.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)VentDoorBlock.box((double)12.01, (double)12.01, (double)0.01, (double)13.99, (double)15.99, (double)15.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)VentDoorBlock.box((double)2.01, (double)12.01, (double)0.01, (double)3.99, (double)15.99, (double)15.99), (VoxelShape[])new VoxelShape[]{VentDoorBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), VentDoorBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        if (world.getBestNeighborSignal(pos) > 0) {
            VentDoorRedstoneOnProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        } else {
            VentDoorRedstoneOffProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        VentDoorUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        VentDoorBlockOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VentDoorBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }
}

