/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.freddyfazbear.entity.FlamethrowerSkinStatueEntity;
import net.mcreator.freddyfazbear.entity.layer.FlamethrowerSkinStatueLayer;
import net.mcreator.freddyfazbear.entity.model.FlamethrowerSkinStatueModel;
import net.mcreator.freddyfazbear.init.FazcraftModParticleTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class FlamethrowerSkinStatueRenderer
extends GeoEntityRenderer<FlamethrowerSkinStatueEntity> {
    public FlamethrowerSkinStatueRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FlamethrowerSkinStatueModel());
        this.shadowRadius = 0.7f;
        this.addRenderLayer(new FlamethrowerSkinStatueLayer((GeoRenderer<FlamethrowerSkinStatueEntity>)this));
    }

    public RenderType getRenderType(FlamethrowerSkinStatueEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }

    public void preRender(PoseStack poseStack, FlamethrowerSkinStatueEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
    }

    protected float getDeathMaxRotation(FlamethrowerSkinStatueEntity entityLivingBaseIn) {
        return 0.0f;
    }

    public void renderRecursively(PoseStack stack, FlamethrowerSkinStatueEntity entity, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer bufferIn, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        double particleSpread = 0.03;
        double particleSpeed = 0.1;
        double particleSpawnChance = 0.3;
        if (bone.getName().equals("flame_tip")) {
            Vector3d boneWorldPos = bone.getWorldPosition();
            Matrix4f modelRotationMatrix = bone.getModelRotationMatrix();
            Matrix3f rotationMatrix = new Matrix3f(modelRotationMatrix.m00(), modelRotationMatrix.m01(), modelRotationMatrix.m02(), modelRotationMatrix.m10(), modelRotationMatrix.m11(), modelRotationMatrix.m12(), modelRotationMatrix.m20(), modelRotationMatrix.m21(), modelRotationMatrix.m22());
            float yaw = entity.getYRot();
            float yawRadians = yaw * ((float)Math.PI / 180);
            Matrix3f yawMatrix = new Matrix3f();
            yawMatrix.rotationY(yawRadians);
            Matrix3f rotatedMatrix = new Matrix3f((Matrix3fc)rotationMatrix);
            rotatedMatrix.mul((Matrix3fc)yawMatrix);
            Vector3f direction = new Vector3f(rotatedMatrix.m02(), rotatedMatrix.m12(), rotatedMatrix.m22());
            direction.rotateY(-1.5707964f);
            if (Math.random() < particleSpawnChance) {
                entity.getCommandSenderWorld().addParticle((ParticleOptions)((SimpleParticleType)FazcraftModParticleTypes.FLAMETHROWER_PARTICLE.get()), boneWorldPos.x, boneWorldPos.y, boneWorldPos.z, (double)direction.x() * particleSpeed + Mth.nextDouble((RandomSource)RandomSource.create(), (double)(-particleSpread), (double)particleSpread), (double)(-direction.y()) * particleSpeed + Mth.nextDouble((RandomSource)RandomSource.create(), (double)(-particleSpread), (double)particleSpread), (double)direction.z() * particleSpeed + Mth.nextDouble((RandomSource)RandomSource.create(), (double)(-particleSpread), (double)particleSpread));
            }
        }
        super.renderRecursively(stack, (Entity)entity, bone, renderType, bufferSource, bufferIn, isReRender, partialTick, packedLight, packedOverlay, renderColor);
    }
}

