/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.init;

import net.mcreator.freddyfazbear.potion.CaffeinatedMobEffect;
import net.mcreator.freddyfazbear.potion.CorruptedMobEffect;
import net.mcreator.freddyfazbear.potion.DisruptionMobEffect;
import net.mcreator.freddyfazbear.potion.HallucinatingMobEffect;
import net.mcreator.freddyfazbear.potion.RoachedMobEffect;
import net.mcreator.freddyfazbear.potion.StunnedMobEffect;
import net.mcreator.freddyfazbear.procedures.HallucinatingEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class FazcraftModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"fazcraft");
    public static final DeferredHolder<MobEffect, MobEffect> HALLUCINATING = REGISTRY.register("hallucinating", () -> new HallucinatingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CORRUPTED = REGISTRY.register("corrupted", () -> new CorruptedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STUNNED = REGISTRY.register("stunned", () -> new StunnedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DISRUPTION = REGISTRY.register("disruption", () -> new DisruptionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CAFFEINATED = REGISTRY.register("caffeinated", () -> new CaffeinatedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ROACHED = REGISTRY.register("roached", () -> new RoachedMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            FazcraftModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            FazcraftModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(HALLUCINATING)) {
            HallucinatingEffectExpiresProcedure.execute(entity);
        }
    }
}

