/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.network;

import java.util.function.Supplier;
import net.mcreator.freddyfazbear.FazcraftMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FazcraftModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"fazcraft");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        FazcraftMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        FazcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fazcraft", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fazcraft", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double flashlightPower = 0.0;
        public double flashlightOverlay = 0.0;
        public double fazcamPower = -1.0;
        public double fazcamOverlay = 0.0;
        public double lockedEntities = 0.0;
        public double bbJumpscare = 0.0;
        public boolean frostbearCon = false;
        public boolean faultyPresent = false;
        public double flamethrowerRisk = 0.0;
        public double flamethrowerTimer = 0.0;
        public double insanity = -5.0;
        public double insanityHallucinationAudio = 0.0;
        public double insanityHallucinationEntity = 12000.0;
        public double insanityHallucinationVisual = 9000.0;
        public double attachX = 0.0;
        public double attachY = 0.0;
        public double attachZ = 0.0;
        public double ropeLength = 0.0;
        public boolean isAttached = false;
        public double ropeUniqueId = 0.0;
        public double bookCooldown = 6000.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("flashlightPower", this.flashlightPower);
            nbt.putDouble("flashlightOverlay", this.flashlightOverlay);
            nbt.putDouble("fazcamPower", this.fazcamPower);
            nbt.putDouble("fazcamOverlay", this.fazcamOverlay);
            nbt.putDouble("lockedEntities", this.lockedEntities);
            nbt.putDouble("bbJumpscare", this.bbJumpscare);
            nbt.putBoolean("frostbearCon", this.frostbearCon);
            nbt.putBoolean("faultyPresent", this.faultyPresent);
            nbt.putDouble("flamethrowerRisk", this.flamethrowerRisk);
            nbt.putDouble("flamethrowerTimer", this.flamethrowerTimer);
            nbt.putDouble("insanity", this.insanity);
            nbt.putDouble("insanityHallucinationAudio", this.insanityHallucinationAudio);
            nbt.putDouble("insanityHallucinationEntity", this.insanityHallucinationEntity);
            nbt.putDouble("insanityHallucinationVisual", this.insanityHallucinationVisual);
            nbt.putDouble("attachX", this.attachX);
            nbt.putDouble("attachY", this.attachY);
            nbt.putDouble("attachZ", this.attachZ);
            nbt.putDouble("ropeLength", this.ropeLength);
            nbt.putBoolean("isAttached", this.isAttached);
            nbt.putDouble("ropeUniqueId", this.ropeUniqueId);
            nbt.putDouble("bookCooldown", this.bookCooldown);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.flashlightPower = nbt.getDouble("flashlightPower");
            this.flashlightOverlay = nbt.getDouble("flashlightOverlay");
            this.fazcamPower = nbt.getDouble("fazcamPower");
            this.fazcamOverlay = nbt.getDouble("fazcamOverlay");
            this.lockedEntities = nbt.getDouble("lockedEntities");
            this.bbJumpscare = nbt.getDouble("bbJumpscare");
            this.frostbearCon = nbt.getBoolean("frostbearCon");
            this.faultyPresent = nbt.getBoolean("faultyPresent");
            this.flamethrowerRisk = nbt.getDouble("flamethrowerRisk");
            this.flamethrowerTimer = nbt.getDouble("flamethrowerTimer");
            this.insanity = nbt.getDouble("insanity");
            this.insanityHallucinationAudio = nbt.getDouble("insanityHallucinationAudio");
            this.insanityHallucinationEntity = nbt.getDouble("insanityHallucinationEntity");
            this.insanityHallucinationVisual = nbt.getDouble("insanityHallucinationVisual");
            this.attachX = nbt.getDouble("attachX");
            this.attachY = nbt.getDouble("attachY");
            this.attachZ = nbt.getDouble("attachZ");
            this.ropeLength = nbt.getDouble("ropeLength");
            this.isAttached = nbt.getBoolean("isAttached");
            this.ropeUniqueId = nbt.getDouble("ropeUniqueId");
            this.bookCooldown = nbt.getDouble("bookCooldown");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "fazcraft_mapvars";
        public double cinematicBBLookCooldown = 0.0;
        public double fazcraftHoliday = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.cinematicBBLookCooldown = nbt.getDouble("cinematicBBLookCooldown");
            this.fazcraftHoliday = nbt.getDouble("fazcraftHoliday");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("cinematicBBLookCooldown", this.cinematicBBLookCooldown);
            nbt.putDouble("fazcraftHoliday", this.fazcraftHoliday);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "fazcraft_worldvars";
        public String adventClaimed = "\"\"";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.adventClaimed = nbt.getString("adventClaimed");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("adventClaimed", this.adventClaimed);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.flashlightPower = original.flashlightPower;
            clone.fazcamPower = original.fazcamPower;
            clone.lockedEntities = original.lockedEntities;
            clone.bbJumpscare = original.bbJumpscare;
            clone.insanity = original.insanity;
            clone.insanityHallucinationAudio = original.insanityHallucinationAudio;
            clone.insanityHallucinationEntity = original.insanityHallucinationEntity;
            clone.insanityHallucinationVisual = original.insanityHallucinationVisual;
            clone.attachX = original.attachX;
            clone.attachY = original.attachY;
            clone.attachZ = original.attachZ;
            clone.ropeLength = original.ropeLength;
            clone.isAttached = original.isAttached;
            clone.ropeUniqueId = original.ropeUniqueId;
            clone.bookCooldown = original.bookCooldown;
            if (!event.isWasDeath()) {
                clone.flashlightOverlay = original.flashlightOverlay;
                clone.fazcamOverlay = original.fazcamOverlay;
                clone.frostbearCon = original.frostbearCon;
                clone.faultyPresent = original.faultyPresent;
                clone.flamethrowerRisk = original.flamethrowerRisk;
                clone.flamethrowerTimer = original.flamethrowerTimer;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

