/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.freddyfazbear.mixins;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public abstract class ElytraLayerMixin {
    @Unique
    private ResourceLocation playerElytra = null;
    @Unique
    private static final Map<UUID, String> rankCache = new ConcurrentHashMap<UUID, String>();
    @Unique
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    @Unique
    private static final Map<String, ResourceLocation> RANK_ELYTRAS = Map.of("DEVELOPER", ResourceLocation.parse((String)"fazcraft:textures/capes/cape_developer.png"), "SUPPORTER", ResourceLocation.parse((String)"fazcraft:textures/capes/cape_supporter.png"), "TESTER", ResourceLocation.parse((String)"fazcraft:textures/capes/cape_tester.png"), "FLASHLIGHT", ResourceLocation.parse((String)"fazcraft:textures/capes/cape_flashlight.png"), "MATHMAN", ResourceLocation.parse((String)"fazcraft:textures/capes/cape_mathman.png"));

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(PoseStack ps, MultiBufferSource mbs, int i1, LivingEntity entity, float f1, float f2, float f3, float f4, float f5, float f6, CallbackInfo cir) {
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        UUID uuid = player.getUUID();
        String cached = rankCache.get(uuid);
        if (cached == null) {
            rankCache.put(uuid, "FETCHING");
            this.fetchRankAsync(uuid);
            this.playerElytra = null;
            return;
        }
        this.playerElytra = !"FETCHING".equals(cached) && RANK_ELYTRAS.containsKey(cached) ? RANK_ELYTRAS.get(cached) : null;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/PlayerSkin;elytraTexture()Lnet/minecraft/resources/ResourceLocation;"))
    private ResourceLocation injected(PlayerSkin skin) {
        return this.playerElytra != null ? this.playerElytra : skin.elytraTexture();
    }

    @Unique
    private void fetchRankAsync(UUID uuid) {
        String url = "https://api.mrrp.dev/v1/fazcraft/" + String.valueOf(uuid);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            try {
                int status = response.statusCode();
                if (status == 200) {
                    JsonObject json = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
                    if (json.has("success") && json.get("success").getAsBoolean()) {
                        String rank = json.getAsJsonObject("data").get("rank").getAsString();
                        rankCache.put(uuid, rank);
                    } else {
                        rankCache.put(uuid, "NONE");
                    }
                } else if (status == 404) {
                    rankCache.put(uuid, "NONE");
                } else {
                    rankCache.put(uuid, "NONE");
                }
            }
            catch (Exception e) {
                rankCache.put(uuid, "NONE");
            }
        });
    }
}

