/*
 * Decompiled with CFR 0.152.
 */
package screenbases;

import datadiver.Changeswitches;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MinigameUtils {
    private static final Map<String, List<Button>> BUTTON_STORE = new HashMap<String, List<Button>>();
    private static final Map<String, Screen> SCREEN_STORE = new HashMap<String, Screen>();

    @OnlyIn(value=Dist.CLIENT)
    public static void saveScreenNbt(Screen screen, CompoundTag nbt) {
        if (screen instanceof IEntityDataSaver) {
            IEntityDataSaver saver = (IEntityDataSaver)screen;
            CompoundTag data = saver.getPersistentData();
            data.merge(nbt);
        }
    }

    public static void saveBlockNbt(BlockPos pos, CompoundTag nbt) {
        BlockEntity block = Minecraft.getInstance().level.getBlockEntity(pos);
        if (block instanceof IEntityDataSaver) {
            IEntityDataSaver saver = (IEntityDataSaver)block;
            CompoundTag data = saver.getPersistentData();
            data.merge(nbt);
            block.setChanged();
        }
    }

    public static void saveScreen(String key, Screen screen) {
        SCREEN_STORE.put(key, screen);
    }

    public static <T extends Screen> T loadScreen(String key) {
        return (T)SCREEN_STORE.get(key);
    }

    public static void saveButtons(String key, List<Changeswitches> buttons) {
        BUTTON_STORE.put(key + "_buttons", new ArrayList<Changeswitches>(buttons));
    }

    public static List<Button> loadButtons(String key) {
        return BUTTON_STORE.getOrDefault(key + "_buttons", new ArrayList());
    }

    public static void clearScreen(String key) {
        SCREEN_STORE.remove(key);
    }

    public static interface IEntityDataSaver {
        public CompoundTag getPersistentData();
    }
}

