/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_item_frames.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;

public class BIFConfig {
    private static BIFConfig instance;
    private static final String CONFIG_FILE_NAME = "better_item_frames-config.toml";
    private FileConfig config;

    private BIFConfig() {
        this.load();
    }

    public static BIFConfig getInstance() {
        if (instance == null) {
            instance = new BIFConfig();
            instance.load();
        }
        return instance;
    }

    private Path getConfigFile() {
        Path gameDir = Minecraft.getInstance().gameDirectory.toPath();
        Path configDir = gameDir.resolve("config");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create config directory: " + e.getMessage());
        }
        return configDir.resolve(CONFIG_FILE_NAME);
    }

    public void load() {
        Path configPath = this.getConfigFile();
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.createDefaultConfig(configPath);
        }
        this.config = FileConfig.builder((Path)configPath).build();
        this.config.load();
        this.ensureDefaults();
        this.config.save();
    }

    private void createDefaultConfig(Path configPath) {
        try {
            String defaultConfig = "# Better Item Frames Mod Configuration File\n# This file uses TOML format and supports comments\n\n[gameplay]\n# Splash potion range configuration\n# Controls the range of splash potions when thrown\n# Available options:\n#   \"vanilla\" - Vanilla range: Use the original Minecraft splash potion range\n#   \"half\"    - Half range: Reduce the splash potion range to half of vanilla\n# Default value: \"vanilla\"\nsplash_potion_range = \"vanilla\"\n";
            Files.writeString(configPath, (CharSequence)defaultConfig, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create default BetterItemFrames config: " + e.getMessage());
        }
    }

    private void ensureDefaults() {
        if (!this.config.contains("gameplay.splash_potion_range")) {
            this.config.set("gameplay.splash_potion_range", (Object)SplashPotionRange.VANILLA.getValue());
        }
    }

    public SplashPotionRange getSplashPotionRange() {
        String value = (String)this.config.get("gameplay.splash_potion_range");
        return SplashPotionRange.fromString(value != null ? value : SplashPotionRange.VANILLA.getValue());
    }

    public void setSplashPotionRange(SplashPotionRange range) {
        this.config.set("gameplay.splash_potion_range", (Object)range.getValue());
        this.config.save();
    }

    public void reload() {
        if (this.config != null) {
            this.config.load();
        }
    }

    public void save() {
        if (this.config != null) {
            this.config.save();
        }
    }

    public void close() {
        if (this.config != null) {
            this.config.close();
        }
    }

    public static enum SplashPotionRange {
        VANILLA("vanilla"),
        HALF("half");

        private final String value;

        private SplashPotionRange(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SplashPotionRange fromString(String value) {
            for (SplashPotionRange range : SplashPotionRange.values()) {
                if (!range.getValue().equals(value)) continue;
                return range;
            }
            return VANILLA;
        }
    }
}

