/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_item_frames.mixin;

import com.euphony.better_item_frames.api.ICustomItemFrame;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFrame.class})
public abstract class ItemFrameMixin
extends HangingEntity
implements ICustomItemFrame {
    @Unique
    private boolean better_item_frames$isInvisible;

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    protected ItemFrameMixin(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setItem(Lnet/minecraft/world/item/ItemStack;Z)V"}, at={@At(value="TAIL")})
    private void setHeldItem(ItemStack value, boolean update, CallbackInfo ci) {
        if (this.better_item_frames$isInvisible) {
            ((ItemFrame)this).setInvisible(true);
        } else {
            ((ItemFrame)this).setInvisible(false);
        }
    }

    @Inject(method={"removeFramedMap(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void removeFromFrameMixin(ItemStack stack, CallbackInfo ci) {
        ((ItemFrame)this).setInvisible(false);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void addAdditionalSaveDataInject(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putBoolean("isInvisible", this.better_item_frames$isInvisible);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void readAdditionalSaveDataInject(ValueInput valueInput, CallbackInfo ci) {
        this.better_item_frames$isInvisible = valueInput.getBooleanOr("isInvisible", false);
    }

    @Override
    public boolean better_item_frames$getIsInvisible() {
        return this.better_item_frames$isInvisible;
    }

    @Override
    public void better_item_frames$setIsInvisible(boolean isInvisible) {
        this.better_item_frames$isInvisible = isInvisible;
        if (!this.getItem().isEmpty()) {
            this.setItem(this.getItem());
        }
    }
}

