/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.better_item_frames.utils;

import com.euphony.better_item_frames.api.ICustomItemFrame;
import com.euphony.better_item_frames.config.BIFConfig;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.phys.AABB;

public class Utils {
    public static void handleInvisibility(AbstractThrownPotion thrownPotion, Iterable<MobEffectInstance> effects) {
        effects.forEach(effect -> {
            if (effect.is(MobEffects.INVISIBILITY)) {
                Utils.setInvisibility(thrownPotion, true);
            }
        });
    }

    public static void setInvisibility(AbstractThrownPotion thrownPotion, boolean invisibility) {
        AABB checkBox = Utils.getBoundingBox(thrownPotion);
        List itemFrames = thrownPotion.level().getEntitiesOfClass(ItemFrame.class, checkBox);
        for (ItemFrame frame : itemFrames) {
            ICustomItemFrame itemFrame = (ICustomItemFrame)frame;
            if (invisibility == itemFrame.better_item_frames$getIsInvisible()) continue;
            itemFrame.better_item_frames$setIsInvisible(invisibility);
        }
    }

    private static AABB getBoundingBox(AbstractThrownPotion thrownPotion) {
        if (BIFConfig.getInstance().getSplashPotionRange() == BIFConfig.SplashPotionRange.HALF) {
            return thrownPotion.getBoundingBox().inflate(2.0, 1.0, 2.0);
        }
        return thrownPotion.getBoundingBox().inflate(4.0, 2.0, 4.0);
    }
}

