/*
 * Decompiled with CFR 0.152.
 */
package eu.netleak.guiscaler.core;

import eu.netleak.guiscaler.core.ScaleMode;
import java.util.Map;

public class GUIScaleCalculator {
    public static int calculateOptimalScale(int width, int height, ScaleMode mode, Map<Integer, Integer> customRules) {
        if (mode == ScaleMode.CUSTOM) {
            return GUIScaleCalculator.calculateCustomScale(width, customRules);
        }
        return GUIScaleCalculator.calculateAutoScale(width, height);
    }

    private static int calculateAutoScale(int width, int height) {
        int totalPixels = width * height;
        if (width >= 2560 || totalPixels > 4500000) {
            return 3;
        }
        if (width >= 1920 || totalPixels > 2000000) {
            return 2;
        }
        if (width >= 1280) {
            return 1;
        }
        return 0;
    }

    private static int calculateCustomScale(int width, Map<Integer, Integer> rules) {
        return rules.entrySet().stream().filter(e -> width >= (Integer)e.getKey()).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElse(0);
    }
}

