/*
 * Decompiled with CFR 0.152.
 */
package eu.netleak.guiscaler;

import eu.netleak.guiscaler.Constants;
import eu.netleak.guiscaler.core.GUIScaleCalculator;
import eu.netleak.guiscaler.core.ScaleMode;
import eu.netleak.guiscaler.platform.Services;
import java.util.Map;

public class CommonClass {
    private static ConfigProvider configProvider;

    public static void init() {
        Constants.LOG.info("{} initialized on {}", (Object)"GUI Scaler", (Object)Services.PLATFORM.getPlatformName());
    }

    public static void setConfigProvider(ConfigProvider provider) {
        configProvider = provider;
    }

    public static void onScreenInit() {
        Map<Integer, Integer> customRules;
        if (configProvider == null || !configProvider.isAutoScaleEnabled()) {
            return;
        }
        int width = Services.PLATFORM.getWindowWidth();
        int height = Services.PLATFORM.getWindowHeight();
        int currentScale = Services.PLATFORM.getCurrentGuiScale();
        ScaleMode mode = configProvider.getScaleMode();
        int newScale = GUIScaleCalculator.calculateOptimalScale(width, height, mode, customRules = configProvider.getCustomRules());
        if (newScale != currentScale) {
            Services.PLATFORM.setGuiScale(newScale);
            Constants.LOG.info("GUI scale changed: {} \u2192 {} ({}x{})", new Object[]{currentScale, newScale, width, height});
        }
    }

    public static interface ConfigProvider {
        public boolean isAutoScaleEnabled();

        public ScaleMode getScaleMode();

        public Map<Integer, Integer> getCustomRules();
    }
}

