/*
 * Decompiled with CFR 0.152.
 */
package eu.netleak.guiscaler;

import eu.netleak.guiscaler.CommonClass;
import eu.netleak.guiscaler.Constants;
import eu.netleak.guiscaler.config.GuiScalerConfig;
import eu.netleak.guiscaler.core.ScaleMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="guiscaler")
public class GuiScaler {
    public GuiScaler(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GuiScalerConfig.CLIENT_CONFIG);
        CommonClass.init();
        CommonClass.setConfigProvider(new CommonClass.ConfigProvider(this){

            @Override
            public boolean isAutoScaleEnabled() {
                return (Boolean)GuiScalerConfig.ENABLE_AUTO_SCALE.get();
            }

            @Override
            public ScaleMode getScaleMode() {
                return (ScaleMode)((Object)GuiScalerConfig.MODE.get());
            }

            @Override
            public Map<Integer, Integer> getCustomRules() {
                HashMap<Integer, Integer> rules = new HashMap<Integer, Integer>();
                for (String rule : (List)GuiScalerConfig.CUSTOM_RULES.get()) {
                    try {
                        String[] parts = rule.split(":");
                        if (parts.length != 2) continue;
                        int width = Integer.parseInt(parts[0]);
                        int scale = Integer.parseInt(parts[1]);
                        rules.put(width, scale);
                    }
                    catch (NumberFormatException e) {
                        Constants.LOG.error("Invalid custom rule format: {}", (Object)rule);
                    }
                }
                return rules;
            }
        });
        NeoForge.EVENT_BUS.register((Object)new ScreenEventHandler());
    }

    public static class ScreenEventHandler {
        @SubscribeEvent
        public void onScreenInit(ScreenEvent.Init.Post event) {
            CommonClass.onScreenInit();
        }
    }
}

