/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.condition;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import team.creative.ambientsounds.condition.AmbientSelection;
import team.creative.ambientsounds.condition.AmbientTime;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.condition.BiomeCondition;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.entity.AmbientEntityCondition;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.environment.BiomeEnvironment;
import team.creative.ambientsounds.region.AmbientRegion;
import team.creative.ambientsounds.sound.AmbientSoundProperties;
import team.creative.creativecore.common.util.type.list.Pair;

public class AmbientCondition
extends AmbientSoundProperties {
    public Boolean always;
    public double volume = 1.0;
    @SerializedName(value="night")
    public double nightVolume = 1.0;
    @SerializedName(value="day")
    public double dayVolume = 1.0;
    public AmbientTime time;
    @SerializedName(value="biome-type")
    public String biomeType;
    public String[] biomes;
    protected transient BiomeCondition[] biomesCompiled;
    @SerializedName(value="bad-biomes")
    public String[] badBiomes;
    protected transient BiomeCondition[] badBiomesCompiled;
    public Boolean raining;
    @SerializedName(value="overall-raining")
    public Boolean overallRaining;
    public Boolean snowing;
    public Boolean storming;
    public AmbientMinMaxFadeCondition underwater;
    @SerializedName(value="relative-height")
    public AmbientMinMaxFadeSpecialCondition relativeHeight;
    @SerializedName(value="absolute-height")
    public AmbientMinMaxFadeCondition absoluteHeight;
    @SerializedName(value="min-height-relative")
    public AmbientMinMaxFadeCondition minHeightRelative;
    @SerializedName(value="max-height-relative")
    public AmbientMinMaxFadeCondition maxHeightRelative;
    public AmbientMinMaxFadeCondition light;
    @SerializedName(value="sky-light")
    public AmbientMinMaxFadeCondition skyLight;
    public AmbientMinMaxFadeCondition air;
    public AmbientMinMaxFadeCondition temperature;
    public String[] features;
    @SerializedName(value="bad-features")
    public String[] badFeatures;
    public AmbientCondition[] variants;
    public String[] regions;
    protected transient List<AmbientRegion> regionList;
    @SerializedName(value="bad-regions")
    public String[] badRegions;
    protected transient List<AmbientRegion> badRegionList;
    public AmbientEntityCondition entity;

    public String regionName() {
        return null;
    }

    @Override
    public void init(AmbientEngine engine) throws AmbientEngineLoadException {
        AmbientRegion region;
        super.init(engine);
        this.volume = Mth.clamp((double)this.volume, (double)0.0, (double)1.0);
        this.nightVolume = Mth.clamp((double)this.nightVolume, (double)0.0, (double)1.0);
        this.dayVolume = Mth.clamp((double)this.dayVolume, (double)0.0, (double)1.0);
        if (this.variants != null) {
            for (int i = 0; i < this.variants.length; ++i) {
                this.variants[i].init(engine);
            }
        }
        this.biomesCompiled = BiomeCondition.of(this.biomes);
        this.badBiomesCompiled = BiomeCondition.of(this.badBiomes);
        if (this.regions != null) {
            this.regionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.regions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.regionList.add(region);
            }
        }
        if (this.badRegions != null) {
            this.badRegionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.badRegions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.badRegionList.add(region);
            }
        }
        if (this.biomeType == null) {
            this.biomeType = engine.defaultBiomeType;
        }
        if (this.entity != null) {
            this.entity.init(engine);
        }
    }

    public AmbientSelection value(AmbientEnvironment env) {
        double volume;
        if (env.muted) {
            return null;
        }
        if (this.always != null) {
            return this.always != false ? new AmbientSelection(this) : null;
        }
        if (this.volume <= 0.0) {
            return null;
        }
        if (env.night ? this.nightVolume <= 0.0 : this.dayVolume <= 0.0) {
            return null;
        }
        if (this.raining != null && this.raining != env.raining) {
            return null;
        }
        if (this.overallRaining != null && this.overallRaining.booleanValue() != env.isRainAudibleAtSurface()) {
            return null;
        }
        if (this.snowing != null && this.snowing != env.snowing) {
            return null;
        }
        if (this.storming != null && env.thundering != this.storming) {
            return null;
        }
        if (this.badFeatures != null && env.terrain.airPocket.volume(this.badFeatures) > 0.0) {
            return null;
        }
        AmbientSelection selection = new AmbientSelection(this);
        selection.mulCondition(env.night ? this.nightVolume : this.dayVolume);
        if (this.time != null) {
            double value = this.time.value(env);
            if (value <= 0.0) {
                return null;
            }
            selection.mulCondition(value);
        }
        if (this.badRegionList != null) {
            for (AmbientRegion region : this.badRegionList) {
                if (!region.isActive()) continue;
                return null;
            }
        }
        if (this.regionList != null) {
            AmbientSelection highest = null;
            for (AmbientRegion region : this.regionList) {
                AmbientSelection subSelection = region.value(env);
                if (subSelection != null && (highest == null || subSelection.volume() > ((AmbientVolume)highest).volume())) {
                    highest = subSelection;
                }
                if (highest == null || ((AmbientVolume)highest).volume() != 1.0) continue;
                break;
            }
            if (highest == null) {
                return null;
            }
            selection.mulVolume(highest);
        }
        if (this.biomes != null || this.badBiomes != null) {
            AmbientVolume highest = null;
            for (Pair pair : env.biome) {
                if (this.biomes != null && !((BiomeEnvironment.BiomeArea)pair.key).checkBiome(this.biomesCompiled)) continue;
                if (this.badBiomes != null && ((BiomeEnvironment.BiomeArea)pair.key).checkBiome(this.badBiomesCompiled)) {
                    return null;
                }
                if (this.biomes == null) continue;
                AmbientVolume volume2 = ((AmbientVolume)pair.value).copy();
                volume2.mulVolume(env.biomeTypeVolumes.getOrDefault(this.biomeType, AmbientVolume.MAX));
                if (highest == null || highest.volume() < volume2.volume()) {
                    highest = volume2;
                }
                if (highest == null || highest.volume() != 1.0) continue;
                break;
            }
            if (highest == null && this.biomes != null) {
                return null;
            }
            if (highest != null) {
                selection.mulVolume(highest);
            }
        }
        if (this.overallRaining != null && this.overallRaining.booleanValue()) {
            selection.mulCondition(env.rainSurfaceVolume);
        }
        if (this.underwater != null) {
            volume = this.underwater.volume(env.underwater);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.relativeHeight != null) {
            volume = this.relativeHeight.volume(env.relativeMinHeight, env.relativeHeight, env.relativeMaxHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.minHeightRelative != null) {
            volume = this.minHeightRelative.volume(env.relativeMinHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.maxHeightRelative != null) {
            volume = this.maxHeightRelative.volume(env.relativeMaxHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.absoluteHeight != null) {
            volume = this.absoluteHeight.volume(env.absoluteHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.light != null) {
            volume = this.light.volume(env.terrain.airPocket.averageLight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.skyLight != null) {
            volume = this.skyLight.volume(env.terrain.airPocket.averageSkyLight);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.air != null) {
            volume = this.air.volume(env.terrain.airPocket.air);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.features != null) {
            volume = env.terrain.airPocket.volume(this.features);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.temperature != null) {
            volume = this.temperature.volume(env.temperature);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.entity != null) {
            volume = this.entity.value(env);
            if (volume <= 0.0) {
                return null;
            }
            selection.mulCondition(volume);
        }
        if (this.variants != null) {
            AmbientSelection bestCondition = null;
            for (AmbientCondition condition : this.variants) {
                AmbientSelection subSelection = condition.value(env);
                if (subSelection == null || bestCondition != null && !(bestCondition.volume() < subSelection.volume())) continue;
                bestCondition = subSelection;
            }
            if (bestCondition == null) {
                return null;
            }
            selection.subSelection = bestCondition;
        }
        return selection;
    }

    public static class AmbientMinMaxFadeCondition
    extends AmbientMinMaxCondition {
        public Double fade;

        public double volume(double value) {
            if (!this.is(value)) {
                return 0.0;
            }
            if (this.fade == null) {
                return 1.0;
            }
            double volume = 1.0;
            if (this.min != null) {
                volume = Mth.clamp((double)(Math.abs(value - this.min) / this.fade), (double)0.0, (double)1.0);
            }
            if (this.max != null) {
                volume = Math.min(volume, Mth.clamp((double)(Math.abs(value - this.max) / this.fade), (double)0.0, (double)1.0));
            }
            return volume;
        }
    }

    public static class AmbientMinMaxFadeSpecialCondition
    extends AmbientMinMaxFadeCondition {
        public double volume(double min, double value, double max) {
            if (this.fade == null) {
                return this.is(value) ? 1.0 : 0.0;
            }
            double volume = this.volume(value);
            if (volume == 1.0) {
                return volume;
            }
            return Math.max(this.volume(min), this.volume(max));
        }
    }

    public static class AmbientMinMaxCondition {
        public Double min;
        public Double max;

        public boolean is(double value) {
            if (this.min != null && value < this.min) {
                return false;
            }
            return this.max == null || !(value > this.max);
        }

        public double randomValue() {
            if (this.max == null) {
                if (this.min == null) {
                    return 0.0;
                }
                return this.min;
            }
            if (this.min == null) {
                this.min = 0.0;
            }
            double distance = this.max - this.min;
            return Math.random() * distance + this.min;
        }
    }
}

