/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.engine;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.block.AmbientBlockGroup;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngineConfig;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.engine.AmbientLoader;
import team.creative.ambientsounds.engine.AmbientStackType;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.environment.feature.AmbientFeature;
import team.creative.ambientsounds.environment.pocket.AirPocketGroup;
import team.creative.ambientsounds.region.AmbientRegion;
import team.creative.ambientsounds.sound.AmbientSound;
import team.creative.ambientsounds.sound.AmbientSoundCategory;
import team.creative.ambientsounds.sound.AmbientSoundCollection;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.client.render.text.DebugTextRenderer;

public class AmbientEngine {
    public static final ResourceLocation CONFIG_LOCATION = ResourceLocation.tryBuild((String)"ambientsounds", (String)"config.json");
    public static final String ENGINE_LOCATION = "engine.json";
    public static final String DIMENSIONS_LOCATION = "dimensions";
    public static final String REGIONS_LOCATION = "regions";
    public static final String SOUNDCOLLECTIONS_LOCATION = "sound_collections";
    public static final String SOUNDCATEGORIES_LOCATION = "sound_categories";
    public static final String BLOCKGROUPS_LOCATION = "blockgroups";
    public static final String FEATURES_LOCATION = "features";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new Serializer()).create();
    private static String loadedEngine;
    protected transient LinkedHashMap<String, AmbientDimension> dimensions;
    protected transient LinkedHashMap<String, AmbientRegion> allRegions = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientRegion> generalRegions;
    protected transient List<AmbientRegion> activeRegions = new ArrayList<AmbientRegion>();
    protected transient LinkedHashMap<String, AmbientSound> allSounds = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientSoundCategory> soundCategories;
    protected transient List<AmbientSoundCategory> sortedSoundCategories;
    public transient LinkedHashMap<String, AmbientBlockGroup> blockGroups;
    public transient LinkedHashMap<String, AmbientSoundCollection> soundCollections;
    public transient LinkedHashMap<String, AmbientFeature> features;
    public transient AmbientSoundEngine soundEngine;
    protected transient List<String> silentDimensions = new ArrayList<String>();
    protected transient AmbientDimension silentDim;
    protected transient List<Double> airPocketDistanceFactor;
    public transient int maxAirPocketCount;
    public transient AmbientBlockGroup considerSolid;
    public transient double squaredBiomeDistance;
    public String name;
    public String version;
    @SerializedName(value="environment-tick-time")
    public int environmentTickTime = 40;
    @SerializedName(value="sound-tick-time")
    public int soundTickTime = 4;
    @SerializedName(value="block-scan-distance")
    public int blockScanDistance = 40;
    @SerializedName(value="average-height-scan-distance")
    public int averageHeightScanDistance = 2;
    @SerializedName(value="average-height-scan-count")
    public int averageHeightScanCount = 5;
    @SerializedName(value="biome-scan-distance")
    public int biomeScanDistance = 5;
    @SerializedName(value="biome-scan-count")
    public int biomeScanCount = 3;
    @SerializedName(value="air-pocket-count")
    public int airPocketCount = 50000;
    @SerializedName(value="air-pocket-distance")
    public int airPocketDistance = 25;
    @SerializedName(value="air-pocket-groups")
    public AirPocketGroup[] airPocketGroups = new AirPocketGroup[0];
    public String[] solids = new String[0];
    @SerializedName(value="biome-types")
    public String[] biomeTypes = new String[0];
    @SerializedName(value="default-biome-type")
    public String defaultBiomeType;
    @SerializedName(value="fade-volume")
    public Double fadeVolume = 0.005;
    @SerializedName(value="fade-pitch")
    public Double fadePitch = 0.005;

    public static boolean hasLoadedAtLeastOnce() {
        return loadedEngine != null;
    }

    public static boolean hasEngineChanged(String newEngine) {
        return loadedEngine == null || !loadedEngine.equals(newEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmbientEngine attemptToLoadEngine(AmbientSoundEngine soundEngine, ResourceManager manager, String name) throws Exception {
        try (InputStream engineInput = ((Resource)manager.getResource(ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/engine.json"))).orElseThrow()).open();){
            AmbientEngine engine = (AmbientEngine)GSON.fromJson((JsonElement)JsonParser.parseString((String)IOUtils.toString((InputStream)engineInput, (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientEngine.class);
            if (!engine.name.equals(name)) {
                throw new Exception("Invalid engine name");
            }
            engine.dimensions = AmbientEngine.loadMultiple(manager, ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/dimensions")), AmbientDimension.class, x -> x.stack, (dimension, dimensionName, json) -> {
                dimension.name = dimensionName;
                dimension.load(engine, GSON, manager, json);
                if (dimension.loadedRegions != null) {
                    int i = 0;
                    for (AmbientRegion region : dimension.loadedRegions.values()) {
                        if (engine.checkRegion((AmbientDimension)dimension, i, region)) {
                            engine.addRegion(region);
                        }
                        ++i;
                    }
                }
            });
            engine.generalRegions = AmbientEngine.loadMultiple(manager, ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/regions")), AmbientRegion.class, x -> x.stack, (region, regionName, json) -> {
                region.name = regionName;
                region.load(engine, GSON, manager);
                engine.addRegion((AmbientRegion)region);
            });
            engine.blockGroups = new LinkedHashMap();
            String blockGroupPath = name + "/blockgroups";
            int blockGroupSubstring = blockGroupPath.length() + 1;
            Map files = manager.listResourceStacks(blockGroupPath, x -> x.getNamespace().equals("ambientsounds"));
            for (Map.Entry file : files.entrySet()) {
                AmbientBlockGroup group = new AmbientBlockGroup();
                String blockGroupName = ((ResourceLocation)file.getKey()).getPath().substring(blockGroupSubstring).replace(".json", "");
                for (Resource resource : (List)file.getValue()) {
                    try (InputStream input = resource.open();){
                        try {
                            group.add((String[])GSON.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)), String[].class));
                        }
                        catch (JsonSyntaxException e) {
                            AmbientSounds.LOGGER.error("Failed to load blockgroup " + ((ResourceLocation)file.getKey()).toString() + " " + resource.sourcePackId(), (Throwable)e);
                        }
                    }
                }
                engine.blockGroups.put(blockGroupName, group);
            }
            engine.soundCollections = AmbientEngine.loadMultiple(manager, ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/sound_collections")), AmbientSoundCollection.class, x -> x.stack, (soundGroup, soundGroupName, json) -> {});
            engine.soundCategories = AmbientEngine.loadMultiple(manager, ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/sound_categories")), AmbientSoundCategory.class, x -> x.stack, (soundCategory, soundCategoryName, json) -> {
                soundCategory.name = soundCategoryName;
            });
            engine.features = AmbientEngine.loadMultiple(manager, ResourceLocation.tryBuild((String)"ambientsounds", (String)(name + "/features")), AmbientFeature.class, x -> x.stack, (feature, featureName, json) -> {
                feature.name = featureName;
            });
            engine.silentDim = new AmbientDimension();
            engine.silentDim.name = "silent";
            engine.silentDim.volumeSetting = 0.0;
            engine.silentDim.mute = true;
            engine.init();
            engine.soundEngine = soundEngine;
            AmbientSounds.LOGGER.info("Loaded AmbientEngine '{}' v{}. {} dimension(s), {} features, {} blockgroups, {} sound collections, {} regions, {} sounds, {} sound categories, {} solids and {} biome types", new Object[]{engine.name, engine.version, engine.dimensions.size(), engine.features.size(), engine.blockGroups.size(), engine.soundCollections.size(), engine.allRegions.size(), engine.allSounds.size(), engine.soundCategories.size(), engine.solids.length, engine.biomeTypes.length});
            AmbientEngine ambientEngine = engine;
            return ambientEngine;
        }
    }

    public static <T> void applyStackType(T base, T newBase, AmbientStackType stack) {
        for (Field field : base.getClass().getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            try {
                stack.apply(base, field, newBase);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LinkedHashMap<String, T> loadMultiple(ResourceManager manager, ResourceLocation path, Class<T> clazz, Function<T, AmbientStackType> type, AmbientLoader<T> setNameAndInit) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int substring = path.getPath().length() + 1;
        Map files = manager.listResourceStacks(path.getPath(), x -> x.getNamespace().equals(path.getNamespace()));
        for (Map.Entry file : files.entrySet()) {
            Object base = null;
            String name = ((ResourceLocation)file.getKey()).getPath().substring(substring).replace(".json", "");
            for (Resource resource : (List)file.getValue()) {
                try (InputStream input = resource.open();){
                    try {
                        JsonElement json = JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8));
                        Object newBase = GSON.fromJson(json, clazz);
                        if (base == null) {
                            base = newBase;
                        } else {
                            AmbientStackType stack = type.apply(newBase);
                            if (stack == AmbientStackType.overwrite) {
                                base = newBase;
                            } else {
                                AmbientEngine.applyStackType(base, newBase, stack);
                            }
                        }
                        setNameAndInit.setNameAndLoad(base, name, json);
                        map.put(name, base);
                    }
                    catch (JsonSyntaxException | AmbientEngineLoadException e) {
                        AmbientSounds.LOGGER.error("Failed to load " + clazz.getSimpleName() + " in " + ((ResourceLocation)file.getKey()).toString() + " " + resource.sourcePackId(), e);
                    }
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static synchronized AmbientEngine loadAmbientEngine(AmbientSoundEngine soundEngine) {
        try {
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            InputStream input = ((Resource)manager.getResource(CONFIG_LOCATION).orElseThrow()).open();
            AmbientEngineConfig config = (AmbientEngineConfig)GSON.fromJson((JsonElement)JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientEngineConfig.class);
            AmbientSounds.CONFIG.engines.updateArray((Object[])config.engines, (Object)config.defaultEngine);
            loadedEngine = (String)AmbientSounds.CONFIG.engines.get();
            AmbientEngine ambientEngine = AmbientEngine.attemptToLoadEngine(soundEngine, manager, (String)AmbientSounds.CONFIG.engines.get());
            input.close();
            return ambientEngine;
            {
                catch (Exception e) {
                    try {
                        AmbientSounds.LOGGER.error("Sound engine {} could not be loaded", AmbientSounds.CONFIG.engines.get(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        input.close();
                    }
                }
            }
            throw new Exception();
        }
        catch (Exception e) {
            AmbientSounds.LOGGER.error("Not sound engine could be loaded, no sounds will be played!");
            return null;
        }
    }

    public AmbientRegion getRegion(String name) {
        return this.allRegions.get(name);
    }

    protected boolean checkRegion(AmbientDimension dimension, int i, AmbientRegion region) {
        if (region.name == null || region.name.isEmpty()) {
            if (dimension == null) {
                AmbientSounds.LOGGER.error("Found invalid region at {}", (Object)i);
            } else {
                AmbientSounds.LOGGER.error("Found invalid region in '{}' at {}", (Object)dimension.name, (Object)i);
            }
            return false;
        }
        return true;
    }

    protected void addRegion(AmbientRegion region) {
        this.allRegions.put((String)(region.dimension != null ? region.dimension.name + "." : "") + region.name, region);
        region.volumeSetting = 1.0;
        String prefix = (String)(region.dimension != null ? region.dimension.name + "." : "") + region.name + ".";
        if (region.sounds != null) {
            for (AmbientSound sound : region.loadedSounds.values()) {
                this.allSounds.put(prefix + sound.name, sound);
                sound.fullName = prefix + sound.name;
                sound.volumeSetting = 1.0;
            }
        }
    }

    public AmbientDimension getDimension(Level level) {
        String dimensionTypeName = level.dimension().location().toString();
        for (int i = 0; i < this.silentDimensions.size(); ++i) {
            if (!dimensionTypeName.matches(".*" + this.silentDimensions.get(i).toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*")) continue;
            return this.silentDim;
        }
        for (AmbientDimension dimension : this.dimensions.values()) {
            if (!dimension.is(level)) continue;
            return dimension;
        }
        return this.silentDim;
    }

    public void stopEngine() {
        if (!this.activeRegions.isEmpty()) {
            for (AmbientRegion region : this.activeRegions) {
                region.deactivate();
            }
            this.activeRegions.clear();
        }
    }

    public int airPocketVolume(int r) {
        int res = 0;
        int i = r;
        while (r > 0) {
            int f = i == r ? 1 : (i == r - 1 ? 4 : (i == r - 2 ? 7 : 8));
            res = (int)((double)res + (double)(f * r * (r + 1)) * 0.5);
            --r;
        }
        return res;
    }

    public void consumeSoundCollections(String[] groups, Consumer<AmbientSound> consumer) {
        for (int i = 0; i < groups.length; ++i) {
            AmbientSoundCollection group = this.soundCollections.get(groups[i]);
            if (group == null || group.sounds == null) continue;
            for (AmbientSound sound : group.sounds) {
                consumer.accept(sound);
            }
        }
    }

    public void init() throws AmbientEngineLoadException {
        this.airPocketDistanceFactor = new ArrayList<Double>();
        for (int i = 0; i < this.airPocketGroups.length; ++i) {
            for (int subDistance = 0; subDistance < this.airPocketGroups[i].distance; ++subDistance) {
                this.airPocketDistanceFactor.add(this.airPocketGroups[i].weight);
            }
        }
        this.maxAirPocketCount = this.airPocketVolume(this.airPocketDistance);
        for (Map.Entry<String, AmbientSoundCollection> group : this.soundCollections.entrySet()) {
            if (group.getValue().sounds == null) continue;
            for (AmbientSound sound : group.getValue().sounds) {
                sound.name = group.getKey() + "." + sound.name;
                this.allSounds.put(sound.name, sound);
                sound.init(this);
            }
        }
        for (AmbientDimension dimension : this.dimensions.values()) {
            dimension.init(this);
        }
        for (AmbientRegion region : this.allRegions.values()) {
            region.init(this);
        }
        for (AmbientSoundCategory cat : this.soundCategories.values()) {
            cat.init(this);
        }
        this.sortedSoundCategories = new ArrayList<AmbientSoundCategory>();
        HashSet<String> unsorted = new HashSet<String>(this.soundCategories.keySet());
        for (AmbientSoundCategory cat : this.soundCategories.values()) {
            if (cat.parent == null || cat.parent.isBlank()) {
                cat.postInit(unsorted);
                this.sortedSoundCategories.add(cat);
            } else if (cat.parentCategory == null) {
                AmbientSounds.LOGGER.error("Could not parse {} sound category, because the parent '{}' does not exist.", (Object)cat.name, (Object)cat.parent);
            }
            if (!unsorted.isEmpty()) continue;
            break;
        }
        if (!unsorted.isEmpty()) {
            AmbientSounds.LOGGER.error("Could not resolve all sound categories. {} sound categories will be ignored {}.", (Object)unsorted.size(), unsorted);
        }
        this.considerSolid = new AmbientBlockGroup();
        if (this.solids != null) {
            this.considerSolid.add(this.solids);
        }
        this.squaredBiomeDistance = Math.pow(this.biomeScanCount * this.biomeScanDistance * 2, 2.0);
        this.onClientLoad();
    }

    public void onClientLoad() {
        this.blockGroups.values().forEach(x -> x.onClientLoad());
        this.considerSolid.onClientLoad();
    }

    public double airWeightFactor(int distance) {
        if (distance >= this.airPocketDistanceFactor.size()) {
            return 0.0;
        }
        return this.airPocketDistanceFactor.get(distance);
    }

    public void tick(AmbientEnvironment env) {
        for (AmbientSoundCategory cat : this.sortedSoundCategories) {
            cat.tick(env, null);
        }
        if (env.dimension.loadedRegions != null) {
            for (AmbientRegion region : env.dimension.loadedRegions.values()) {
                if (region.tick(env)) {
                    if (region.isActive()) continue;
                    region.activate();
                    this.activeRegions.add(region);
                    continue;
                }
                if (!region.isActive()) continue;
                region.deactivate();
                this.activeRegions.remove(region);
            }
        }
        for (AmbientRegion region : this.generalRegions.values()) {
            if (region.tick(env)) {
                if (region.isActive()) continue;
                region.activate();
                this.activeRegions.add(region);
                continue;
            }
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void fastTick(AmbientEnvironment env) {
        this.soundEngine.tick(env);
        if (!this.activeRegions.isEmpty()) {
            Iterator<AmbientRegion> iterator = this.activeRegions.iterator();
            while (iterator.hasNext()) {
                AmbientRegion region = iterator.next();
                if (region.fastTick(env)) continue;
                region.deactivate();
                iterator.remove();
            }
        }
    }

    public void changeDimension(AmbientEnvironment env, AmbientDimension newDimension) {
        if (env.dimension == null || env.dimension.loadedRegions == null) {
            return;
        }
        for (AmbientRegion region : env.dimension.loadedRegions.values()) {
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void collectDetails(DebugTextRenderer text) {
        text.text(this.name + " v" + this.version);
    }

    public AmbientSoundCategory getSoundCategory(String name) {
        return this.soundCategories.get(name);
    }

    public static class Serializer
    implements JsonDeserializer<ResourceLocation>,
    JsonSerializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement p_135851_, Type p_135852_, JsonDeserializationContext p_135853_) throws JsonParseException {
            return ResourceLocation.parse((String)GsonHelper.convertToString((JsonElement)p_135851_, (String)"location"));
        }

        public JsonElement serialize(ResourceLocation p_135855_, Type p_135856_, JsonSerializationContext p_135857_) {
            return new JsonPrimitive(p_135855_.toString());
        }
    }
}

