/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.pocket.AirPocket;
import team.creative.ambientsounds.environment.pocket.AirPocketScanner;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.text.DebugTextRenderer;

public class TerrainEnvironment {
    public double averageHeight = 60.0;
    public int minHeight = 60;
    public int maxHeight = 60;
    public AirPocket airPocket = new AirPocket();
    public AirPocketScanner scanner;

    public static int getHeightBlock(Level level, BlockPos.MutableBlockPos pos) {
        int heighest = 0;
        for (int y = level.getMaxY(); y > level.getMinY(); --y) {
            pos.setY(y);
            BlockState state = level.getBlockState((BlockPos)pos);
            if (!state.isSolidRender() && !state.is(BlockTags.LEAVES) && !level.getFluidState((BlockPos)pos).is(FluidTags.WATER)) continue;
            heighest = y;
            break;
        }
        return heighest;
    }

    public void analyze(AmbientEngine engine, AmbientDimension dimension, Player player, Level level) {
        this.analyzeHeight(engine, dimension, player, level);
        this.analyzeAirPocket(engine, player, level);
    }

    public void analyzeHeight(AmbientEngine engine, AmbientDimension dimension, Player player, Level level) {
        if (dimension.averageHeight != null) {
            this.averageHeight = dimension.averageHeight.intValue();
            this.minHeight = dimension.averageHeight;
            this.maxHeight = dimension.averageHeight;
            return;
        }
        int sum = 0;
        int count = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos center = player.blockPosition();
        for (int x = -engine.averageHeightScanCount; x <= engine.averageHeightScanCount; ++x) {
            for (int z = -engine.averageHeightScanCount; z <= engine.averageHeightScanCount; ++z) {
                pos.set(center.getX() + engine.averageHeightScanDistance * x, center.getY(), center.getZ() + engine.averageHeightScanDistance * z);
                int height = TerrainEnvironment.getHeightBlock(level, pos);
                min = Math.min(height, min);
                max = Math.max(height, max);
                sum += height;
                ++count;
            }
        }
        this.averageHeight = (double)sum / (double)count;
        this.minHeight = min;
        this.maxHeight = max;
    }

    public void analyzeAirPocket(AmbientEngine engine, Player player, Level level) {
        if (this.scanner == null) {
            this.scanner = new AirPocketScanner(engine, level, BlockPos.containing((Position)player.getEyePosition(CreativeCoreClient.getFrameTime())), x -> {
                this.airPocket = x;
                this.scanner = null;
            });
        }
    }

    public void collectDetails(DebugTextRenderer text) {
        text.detail("features", (Object)this.airPocket.features.toString(DebugTextRenderer.DECIMAL_FORMAT));
        text.detail("light", (Object)this.airPocket.averageLight);
        text.detail("sky-light", (Object)this.airPocket.averageSkyLight);
        text.detail("air", (Object)this.airPocket.air);
    }
}

