/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.command;

import cn.alini.trueuuid.config.TrueuuidConfig;
import cn.alini.trueuuid.server.NameRegistry;
import cn.alini.trueuuid.server.TrueuuidRuntime;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="trueuuid")
public class TrueuuidCommands {
    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        CommandDispatcher d = e.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trueuuid").requires(src -> src.m_6761_(3))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(src -> src.m_6761_(3))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nomojang").then(Commands.m_82127_((String)"status").executes(ctx -> TrueuuidCommands.cmdNomojangStatus((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"on").executes(ctx -> TrueuuidCommands.cmdNomojangSet((CommandSourceStack)ctx.getSource(), true)))).then(Commands.m_82127_((String)"off").executes(ctx -> TrueuuidCommands.cmdNomojangSet((CommandSourceStack)ctx.getSource(), false)))).then(Commands.m_82127_((String)"toggle").executes(ctx -> TrueuuidCommands.cmdNomojangToggle((CommandSourceStack)ctx.getSource())))))).then(Commands.m_82127_((String)"mojang").then(Commands.m_82127_((String)"status").executes(ctx -> TrueuuidCommands.mojangStatus((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"link").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true, true, true, true, true)))).then(Commands.m_82127_((String)"run").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false, true, true, true, true))))).then(Commands.m_82127_((String)"dryrun").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> TrueuuidCommands.run((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true, true, true, true, true)))))).then(Commands.m_82127_((String)"reload").executes(ctx -> TrueuuidCommands.cmdConfigReload((CommandSourceStack)ctx.getSource()))));
    }

    private static int cmdConfigReload(CommandSourceStack src) {
        try {
            Path cfgPath = FMLPaths.CONFIGDIR.get().resolve("trueuuid-common.toml");
            CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)cfgPath).sync().autosave().build();
            cfg.load();
            BiFunction<String, String, Object> getVal = (authKey, altKey) -> {
                if (cfg.contains(authKey)) {
                    return cfg.get(authKey);
                }
                if (altKey != null && cfg.contains(altKey)) {
                    return cfg.get(altKey);
                }
                return null;
            };
            Object v = getVal.apply("auth.nomojang.enabled", "nomojang.enabled");
            if (v instanceof Boolean) {
                TrueuuidConfig.COMMON.nomojangEnabled.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.debug", "debug")) instanceof Boolean) {
                TrueuuidConfig.COMMON.debug.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.recentIpGrace.enabled", "recentIpGrace.enabled")) instanceof Boolean) {
                TrueuuidConfig.COMMON.recentIpGraceEnabled.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.knownPremiumDenyOffline", "knownPremiumDenyOffline")) instanceof Boolean) {
                TrueuuidConfig.COMMON.knownPremiumDenyOffline.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.allowOfflineForUnknownOnly", "allowOfflineForUnknownOnly")) instanceof Boolean) {
                TrueuuidConfig.COMMON.allowOfflineForUnknownOnly.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.allowOfflineOnTimeout", "allowOfflineOnTimeout")) instanceof Boolean) {
                TrueuuidConfig.COMMON.allowOfflineOnTimeout.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.allowOfflineOnFailure", "allowOfflineOnFailure")) instanceof Boolean) {
                TrueuuidConfig.COMMON.allowOfflineOnFailure.set((Object)((Boolean)v));
            }
            if ((v = getVal.apply("auth.timeoutMs", "timeoutMs")) instanceof Number) {
                TrueuuidConfig.COMMON.timeoutMs.set((Object)((Number)v).longValue());
            }
            if ((v = getVal.apply("auth.recentIpGrace.ttlSeconds", "recentIpGrace.ttlSeconds")) instanceof Number) {
                TrueuuidConfig.COMMON.recentIpGraceTtlSeconds.set((Object)((Number)v).intValue());
            }
            if ((v = getVal.apply("auth.timeoutKickMessage", "timeoutKickMessage")) != null) {
                TrueuuidConfig.COMMON.timeoutKickMessage.set((Object)String.valueOf(v));
            }
            if ((v = getVal.apply("auth.offlineFallbackMessage", "offlineFallbackMessage")) != null) {
                TrueuuidConfig.COMMON.offlineFallbackMessage.set((Object)String.valueOf(v));
            }
            if ((v = getVal.apply("auth.offlineShortSubtitle", "offlineShortSubtitle")) != null) {
                TrueuuidConfig.COMMON.offlineShortSubtitle.set((Object)String.valueOf(v));
            }
            if ((v = getVal.apply("auth.onlineShortSubtitle", "onlineShortSubtitle")) != null) {
                TrueuuidConfig.COMMON.onlineShortSubtitle.set((Object)String.valueOf(v));
            }
            src.m_288197_(() -> Component.m_237113_((String)"[TrueUUID] \u914d\u7f6e\u5df2\u4ece\u78c1\u76d8\u91cd\u8f7d").m_130940_(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (Exception ex) {
            src.m_81352_((Component)Component.m_237113_((String)("[TrueUUID] \u91cd\u8f7d\u914d\u7f6e\u5931\u8d25: " + ex.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int cmdNomojangStatus(CommandSourceStack src) {
        boolean enabled = TrueuuidConfig.nomojangEnabled();
        if (enabled) {
            src.m_288197_(() -> Component.m_237113_((String)"[TrueUUID] NoMojang: \u5df2\u542f\u7528").m_130940_(ChatFormatting.GREEN), false);
        } else {
            src.m_288197_(() -> Component.m_237113_((String)"[TrueUUID] NoMojang: \u5df2\u7981\u7528").m_130940_(ChatFormatting.RED), false);
        }
        return 1;
    }

    private static int cmdNomojangSet(CommandSourceStack src, boolean value) {
        try {
            TrueuuidConfig.COMMON.nomojangEnabled.set((Object)value);
            src.m_288197_(() -> Component.m_237113_((String)("[TrueUUID] NoMojang \u5df2" + (value ? "\u542f\u7528" : "\u7981\u7528"))).m_130940_(value ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            return 1;
        }
        catch (Throwable t) {
            src.m_81352_((Component)Component.m_237113_((String)("[TrueUUID] \u65e0\u6cd5\u8bbe\u7f6e NoMojang: " + t.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int cmdNomojangToggle(CommandSourceStack src) {
        boolean current = TrueuuidConfig.nomojangEnabled();
        return TrueuuidCommands.cmdNomojangSet(src, !current);
    }

    private static int mojangStatus(CommandSourceStack src) {
        try {
            String testUrl = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=Mojang&serverId=test";
            URL url = new URL(testUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200 || responseCode == 204 || responseCode == 403) {
                src.m_288197_(() -> Component.m_237113_((String)("[TrueUUID] Mojang \u4f1a\u8bdd\u670d\u52a1\u5668\u53ef\u8bbf\u95ee\uff0c\u54cd\u5e94\u7801: " + responseCode)).m_130940_(ChatFormatting.GREEN), false);
            } else {
                src.m_81352_((Component)Component.m_237113_((String)("[TrueUUID] Mojang \u4f1a\u8bdd\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38\uff0c\u54cd\u5e94\u7801: " + responseCode)).m_130940_(ChatFormatting.RED));
            }
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[TrueUUID] \u65e0\u6cd5\u8fde\u63a5\u5230 Mojang \u4f1a\u8bdd\u670d\u52a1\u5668: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int run(CommandSourceStack src, String name, boolean dryRun, boolean backup, boolean mergeInv, boolean mergeEnder, boolean mergeStats) {
        MinecraftServer server = src.m_81377_();
        Optional<NameRegistry.Entry> reg = TrueuuidCommands.getEntry(name);
        if (reg.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("\u672a\u5728\u6ce8\u518c\u8868\u4e2d\u627e\u5230\u8be5\u540d\u5b57\u7684\u6b63\u7248\u8bb0\u5f55\uff1a" + name)));
            return 0;
        }
        UUID premium = reg.get().premiumUuid;
        UUID offline = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        Path worldRoot = server.m_129843_(LevelResource.f_78182_);
        Path playerData = server.m_129843_(LevelResource.f_78176_);
        Path adv = worldRoot.resolve("advancements");
        Path stats = worldRoot.resolve("stats");
        Path premDat = playerData.resolve(premium + ".dat");
        Path offDat = playerData.resolve(offline + ".dat");
        Path premAdv = adv.resolve(premium + ".json");
        Path offAdv = adv.resolve(offline + ".json");
        Path premStats = stats.resolve(premium + ".json");
        Path offStats = stats.resolve(offline + ".json");
        src.m_288197_(() -> Component.m_237113_((String)("[TrueUUID] link " + (dryRun ? "(dry-run)" : "(run)") + " name=" + name + "\n premium=" + premium + "\n offline=" + offline + "\n files:\n  " + offDat + " -> " + premDat + "\n  " + offAdv + " -> " + premAdv + "\n  " + offStats + " -> " + premStats)), false);
        if (dryRun) {
            return 1;
        }
        try {
            if (backup) {
                String ts = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(LocalDateTime.now());
                Path backupDir = worldRoot.resolve("backups/trueuuid/" + ts + "/" + name.toLowerCase(Locale.ROOT));
                Files.createDirectories(backupDir, new FileAttribute[0]);
                TrueuuidCommands.copyIfExists(premDat, backupDir.resolve("premium.dat"));
                TrueuuidCommands.copyIfExists(offDat, backupDir.resolve("offline.dat"));
                TrueuuidCommands.copyIfExists(premAdv, backupDir.resolve("premium.adv.json"));
                TrueuuidCommands.copyIfExists(offAdv, backupDir.resolve("offline.adv.json"));
                TrueuuidCommands.copyIfExists(premStats, backupDir.resolve("premium.stats.json"));
                TrueuuidCommands.copyIfExists(offStats, backupDir.resolve("offline.stats.json"));
            }
            if (Files.exists(offDat, new LinkOption[0])) {
                if (!Files.exists(premDat, new LinkOption[0])) {
                    Files.move(offDat, premDat, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergePlayerDatNBT(premDat, offDat, mergeInv, mergeEnder);
                }
            }
            if (Files.exists(offAdv, new LinkOption[0])) {
                if (!Files.exists(premAdv, new LinkOption[0])) {
                    Files.move(offAdv, premAdv, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergeAdvancementsJson(premAdv, offAdv);
                }
            }
            if (Files.exists(offStats, new LinkOption[0])) {
                if (!Files.exists(premStats, new LinkOption[0])) {
                    Files.move(offStats, premStats, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    TrueuuidCommands.mergeStatsJson(premStats, offStats);
                }
            }
            src.m_288197_(() -> Component.m_237113_((String)"\u5b8c\u6210\u3002\u5efa\u8bae\u73a9\u5bb6\u4e0b\u6b21\u4ee5\u6b63\u7248\u767b\u5f55\u786e\u8ba4\u6570\u636e\u3002"), false);
            return 1;
        }
        catch (Exception ex) {
            src.m_81352_((Component)Component.m_237113_((String)("\u5931\u8d25\uff1a" + ex.getMessage())));
            ex.printStackTrace();
            return 0;
        }
    }

    private static Optional<NameRegistry.Entry> getEntry(String name) {
        try {
            Field f = NameRegistry.class.getDeclaredField("map");
            f.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return TrueuuidRuntime.NAME_REGISTRY.getPremiumUuid(name).map(u -> {
            NameRegistry.Entry e = new NameRegistry.Entry();
            e.premiumUuid = u;
            return e;
        });
    }

    private static void copyIfExists(Path from, Path to) throws Exception {
        if (Files.exists(from, new LinkOption[0])) {
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void mergePlayerDatNBT(Path premDat, Path offDat, boolean mergeInv, boolean mergeEnder) throws Exception {
        CompoundTag off;
        CompoundTag prem;
        try (InputStream is = Files.newInputStream(premDat, new OpenOption[0]);){
            prem = NbtIo.m_128939_((InputStream)is);
        }
        is = Files.newInputStream(offDat, new OpenOption[0]);
        try {
            off = NbtIo.m_128939_((InputStream)is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        boolean changed = false;
        if (mergeInv) {
            changed |= TrueuuidCommands.mergeItemListTag(prem, off, "Inventory");
        }
        if (mergeEnder) {
            changed |= TrueuuidCommands.mergeItemListTag(prem, off, "EnderItems");
        }
        if (changed) {
            try (OutputStream os = Files.newOutputStream(premDat, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                NbtIo.m_128947_((CompoundTag)prem, (OutputStream)os);
            }
        }
    }

    private static boolean mergeItemListTag(CompoundTag prem, CompoundTag off, String key) {
        if (!prem.m_128441_(key) || !off.m_128441_(key)) {
            return false;
        }
        ListTag premList = prem.m_128437_(key, 10);
        ListTag offList = off.m_128437_(key, 10);
        HashSet<Integer> premSlots = new HashSet<Integer>();
        for (int i = 0; i < premList.size(); ++i) {
            CompoundTag tag = premList.m_128728_(i);
            if (!tag.m_128441_("Slot")) continue;
            premSlots.add(Integer.valueOf(tag.m_128445_("Slot")));
        }
        boolean changed = false;
        for (int i = 0; i < offList.size(); ++i) {
            byte slot;
            CompoundTag tag = offList.m_128728_(i);
            if (!tag.m_128441_("Slot") || premSlots.contains(slot = tag.m_128445_("Slot"))) continue;
            premList.add((Object)tag.m_6426_());
            changed = true;
        }
        if (changed) {
            prem.m_128365_(key, (Tag)premList);
        }
        return changed;
    }

    private static void mergeAdvancementsJson(Path premAdv, Path offAdv) throws Exception {
        JsonObject off;
        JsonObject prem;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader r = Files.newBufferedReader(premAdv);){
            prem = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        r = Files.newBufferedReader(offAdv);
        try {
            off = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
        boolean changed = false;
        for (String key : off.keySet()) {
            if (prem.has(key)) continue;
            prem.add(key, off.get(key));
            changed = true;
        }
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(premAdv, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)prem, (Appendable)w);
            }
        }
    }

    private static void mergeStatsJson(Path premStats, Path offStats) throws Exception {
        JsonObject off;
        JsonObject prem;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader r = Files.newBufferedReader(premStats);){
            prem = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        r = Files.newBufferedReader(offStats);
        try {
            off = (JsonObject)gson.fromJson((Reader)r, JsonObject.class);
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
        boolean changed = false;
        for (String cat : off.keySet()) {
            JsonElement offElem = off.get(cat);
            if (!prem.has(cat)) {
                prem.add(cat, offElem);
                changed = true;
                continue;
            }
            JsonElement premElem = prem.get(cat);
            if (offElem.isJsonObject() && premElem.isJsonObject()) {
                JsonObject offCat = offElem.getAsJsonObject();
                JsonObject premCat = premElem.getAsJsonObject();
                for (String key : offCat.keySet()) {
                    JsonElement offVal = offCat.get(key);
                    if (!premCat.has(key)) {
                        premCat.add(key, offVal);
                        changed = true;
                        continue;
                    }
                    JsonElement premVal = premCat.get(key);
                    if (!premVal.isJsonPrimitive() || !offVal.isJsonPrimitive()) continue;
                    JsonPrimitive pPri = premVal.getAsJsonPrimitive();
                    JsonPrimitive oPri = offVal.getAsJsonPrimitive();
                    if (!pPri.isNumber() || !oPri.isNumber()) continue;
                    try {
                        long a = pPri.getAsLong();
                        long b = oPri.getAsLong();
                        premCat.addProperty(key, (Number)(a + b));
                        changed = true;
                    }
                    catch (Exception exception) {}
                }
                prem.add(cat, (JsonElement)premCat);
                continue;
            }
            if (!premElem.isJsonPrimitive() || !offElem.isJsonPrimitive()) continue;
            JsonPrimitive pPri = premElem.getAsJsonPrimitive();
            JsonPrimitive oPri = offElem.getAsJsonPrimitive();
            if (!pPri.isNumber() || !oPri.isNumber()) continue;
            try {
                long a = pPri.getAsLong();
                long b = oPri.getAsLong();
                prem.addProperty(cat, (Number)(a + b));
                changed = true;
            }
            catch (Exception exception) {}
        }
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(premStats, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
                gson.toJson((JsonElement)prem, (Appendable)w);
            }
        }
    }
}

