/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.mixin.server;

import cn.alini.trueuuid.config.TrueuuidConfig;
import cn.alini.trueuuid.net.NetIds;
import cn.alini.trueuuid.server.AuthDecider;
import cn.alini.trueuuid.server.AuthState;
import cn.alini.trueuuid.server.SessionCheck;
import cn.alini.trueuuid.server.TrueuuidRuntime;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.server.network.ServerLoginPacketListenerImpl"})
public abstract class ServerLoginMixin {
    @Shadow
    private GameProfile f_10021_;
    @Shadow
    private MinecraftServer f_10018_;
    @Shadow
    private Connection f_10013_;
    @Unique
    private static final AtomicInteger TRUEUUID$NEXT_TX_ID = new AtomicInteger(1);
    @Unique
    private int trueuuid$txId = 0;
    @Unique
    private String trueuuid$nonce = null;
    @Unique
    private long trueuuid$sentAt = 0L;
    @Unique
    private volatile boolean trueuuid$ackHandled = false;

    @Shadow
    public abstract void m_10053_(Component var1);

    @Inject(method={"handleHello"}, at={@At(value="TAIL")})
    private void trueuuid$afterHello(ServerboundHelloPacket pkt, CallbackInfo ci) {
        if (this.f_10018_.m_129797_() || this.f_10021_ == null) {
            return;
        }
        if (TrueuuidConfig.nomojangEnabled()) {
            UUID premium;
            Optional<UUID> pOpt;
            String ip;
            String name = this.f_10021_.getName();
            SocketAddress socketAddress = this.f_10013_.m_129523_();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                ip = isa.getAddress().getHostAddress();
            } else {
                ip = null;
            }
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] nomojang \u6a21\u5f0f\uff1a\u8df3\u8fc7 Mojang \u4f1a\u8bdd\u8ba4\u8bc1, \u73a9\u5bb6: " + (name != null ? name : "<unknown>") + ", ip: " + ip);
            }
            if (TrueuuidConfig.recentIpGraceEnabled() && ip != null && (pOpt = TrueuuidRuntime.IP_GRACE.tryGrace(name, ip, TrueuuidConfig.recentIpGraceTtlSeconds())).isPresent() && (premium = pOpt.get()) != null) {
                GameProfile newProfile;
                if (TrueuuidConfig.debug()) {
                    System.out.println("[TrueUUID] nomojang: \u627e\u5230\u540cIP\u6b63\u7248\u8bb0\u5f55\uff0c\u6309\u6b63\u7248\u5904\u7406, uuid=" + premium);
                }
                this.f_10021_ = newProfile = new GameProfile(premium, name);
                TrueuuidRuntime.NAME_REGISTRY.recordSuccess(name, premium, ip);
                TrueuuidRuntime.IP_GRACE.record(name, ip, premium);
                return;
            }
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] nomojang: \u672a\u547d\u4e2d\u540cIP\u6b63\u7248\u8bb0\u5f55\uff0c\u6309\u79bb\u7ebf\u65b9\u5f0f\u653e\u884c");
            }
            return;
        }
        this.trueuuid$ackHandled = false;
        this.trueuuid$nonce = UUID.randomUUID().toString().replace("-", "");
        this.trueuuid$txId = TRUEUUID$NEXT_TX_ID.getAndIncrement();
        this.trueuuid$sentAt = System.currentTimeMillis();
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] handleHello: \u5f00\u59cb\u63e1\u624b, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>"));
            System.out.println("[TrueUUID] \u63e1\u624b nonce: " + this.trueuuid$nonce + ", txId: " + this.trueuuid$txId);
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(this.trueuuid$nonce);
        this.f_10013_.m_129512_((Packet)new ClientboundCustomQueryPacket(this.trueuuid$txId, NetIds.AUTH, buf));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void trueuuid$onTick(CallbackInfo ci) {
        if (this.trueuuid$txId == 0 || this.trueuuid$sentAt == 0L) {
            return;
        }
        long timeoutMs = TrueuuidConfig.timeoutMs();
        if (timeoutMs <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.trueuuid$sentAt < timeoutMs) {
            return;
        }
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] \u63e1\u624b\u8d85\u65f6, txId: " + this.trueuuid$txId);
        }
        if (TrueuuidConfig.allowOfflineOnTimeout()) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] \u8d85\u65f6\u5141\u8bb8\u79bb\u7ebf\u8fdb\u5165");
            }
            AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.TIMEOUT);
            this.reset();
        } else {
            String msg = TrueuuidConfig.timeoutKickMessage();
            MutableComponent reason = Component.m_237113_((String)(msg != null ? msg : "\u767b\u5f55\u8d85\u65f6\uff0c\u672a\u5b8c\u6210\u8d26\u53f7\u6821\u9a8c"));
            this.sendDisconnectWithReason((Component)reason);
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleCustomQueryPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void trueuuid$onLoginCustom(ServerboundCustomQueryPacket packet, CallbackInfo ci) {
        FriendlyByteBuf data;
        if (this.trueuuid$txId == 0) {
            return;
        }
        if (packet.m_179824_() != this.trueuuid$txId) {
            return;
        }
        String ip = null;
        SocketAddress socketAddress = this.f_10013_.m_129523_();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            ip = isa.getAddress().getHostAddress();
        }
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] \u6536\u5230\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5305, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>") + ", ip: " + ip);
        }
        if ((data = packet.m_179825_()) == null) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] \u8ba4\u8bc1\u5931\u8d25, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>") + ", ip: " + ip + ", \u539f\u56e0: \u7f3a\u5c11\u6570\u636e");
            }
            this.handleAuthFailure(ip, "\u7f3a\u5c11\u6570\u636e");
            this.reset();
            ci.cancel();
            return;
        }
        boolean ackOk = false;
        try {
            ackOk = data.readBoolean();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] \u5ba2\u6237\u7aef\u8ba4\u8bc1\u5305ackOk: " + ackOk);
        }
        if (!ackOk) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] \u8ba4\u8bc1\u5931\u8d25, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>") + ", ip: " + ip + ", \u539f\u56e0: \u5ba2\u6237\u7aef\u62d2\u7edd");
            }
            this.handleAuthFailure(ip, "\u5ba2\u6237\u7aef\u62d2\u7edd");
            this.reset();
            ci.cancel();
            return;
        }
        if (this.trueuuid$ackHandled) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] \u91cd\u590d\u8ba4\u8bc1\u5305\u5ffd\u7565, txId: " + this.trueuuid$txId);
            }
            ci.cancel();
            return;
        }
        this.trueuuid$ackHandled = true;
        try {
            Optional<SessionCheck.HasJoinedResult> resOpt = SessionCheck.hasJoined(this.f_10021_.getName(), this.trueuuid$nonce, ip);
            if (resOpt.isEmpty()) {
                if (TrueuuidConfig.debug()) {
                    System.out.println("[TrueUUID] \u8ba4\u8bc1\u5931\u8d25, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>") + ", ip: " + ip + ", \u539f\u56e0: \u4f1a\u8bdd\u65e0\u6548");
                }
                this.handleAuthFailure(ip, "\u4f1a\u8bdd\u65e0\u6548");
                this.reset();
                ci.cancel();
                return;
            }
            SessionCheck.HasJoinedResult res = resOpt.get();
            TrueuuidRuntime.NAME_REGISTRY.recordSuccess(res.name(), res.uuid(), ip);
            TrueuuidRuntime.IP_GRACE.record(res.name(), ip, res.uuid());
            GameProfile newProfile = new GameProfile(res.uuid(), res.name());
            PropertyMap propMap = newProfile.getProperties();
            propMap.removeAll((Object)"textures");
            for (SessionCheck.Property p : res.properties()) {
                if (p.signature() != null) {
                    propMap.put((Object)p.name(), (Object)new Property(p.name(), p.value(), p.signature()));
                    continue;
                }
                propMap.put((Object)p.name(), (Object)new Property(p.name(), p.value()));
            }
            this.f_10021_ = newProfile;
        }
        catch (Throwable t) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID] \u8ba4\u8bc1\u5931\u8d25, \u73a9\u5bb6: " + (this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>") + ", ip: " + ip + ", \u539f\u56e0: \u670d\u52a1\u5668\u5f02\u5e38");
            }
            this.handleAuthFailure(ip, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
        finally {
            this.reset();
            this.trueuuid$ackHandled = false;
            ci.cancel();
        }
    }

    @Unique
    private void handleAuthFailure(String ip, String why) {
        String name;
        String string = name = this.f_10021_ != null ? this.f_10021_.getName() : "<unknown>";
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] \u4f1a\u8bdd\u65e0\u6548, \u73a9\u5bb6: " + name + ", ip: " + ip + ", \u5931\u8d25\u539f\u56e0: " + why);
        }
        AuthDecider.Decision d = AuthDecider.onFailure(name, ip);
        switch (d.kind) {
            case PREMIUM_GRACE: {
                UUID premium;
                UUID uUID = premium = d.premiumUuid != null ? d.premiumUuid : (UUID)TrueuuidRuntime.NAME_REGISTRY.getPremiumUuid(name).orElse(null);
                if (premium != null) {
                    this.f_10021_ = new GameProfile(premium, name);
                    break;
                }
                AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.FAILURE);
                break;
            }
            case OFFLINE: {
                if (TrueuuidConfig.debug()) {
                    System.out.println("[TrueUUID] \u79bb\u7ebf\u8fdb\u5165");
                }
                AuthState.markOfflineFallback(this.f_10013_, AuthState.FallbackReason.FAILURE);
                break;
            }
            case DENY: {
                String msg;
                String string2 = msg = d.denyMessage != null ? d.denyMessage : "\u9274\u6743\u5931\u8d25\uff0c\u5df2\u7981\u6b62\u79bb\u7ebf\u8fdb\u5165\u4ee5\u4fdd\u62a4\u4f60\u7684\u6b63\u7248\u5b58\u6863\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002";
                if (TrueuuidConfig.debug()) {
                    System.out.println("[TrueUUID] \u8ba4\u8bc1\u88ab\u62d2\u7edd, \u73a9\u5bb6: " + name + ", ip: " + ip + ", \u6d88\u606f: " + msg);
                }
                this.sendDisconnectWithReason((Component)Component.m_237113_((String)msg));
            }
        }
    }

    @Unique
    private void sendDisconnectWithReason(Component reason) {
        try {
            this.f_10013_.m_129512_((Packet)new ClientboundLoginDisconnectPacket(reason));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.f_10013_.m_129512_((Packet)new ClientboundDisconnectPacket(reason));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.f_10013_.m_129507_(reason);
    }

    @Unique
    private void reset() {
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID] \u72b6\u6001\u91cd\u7f6e, txId: " + this.trueuuid$txId);
        }
        this.trueuuid$txId = 0;
        this.trueuuid$nonce = null;
        this.trueuuid$sentAt = 0L;
    }
}

