/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.server;

import cn.alini.trueuuid.config.TrueuuidConfig;
import cn.alini.trueuuid.server.TrueuuidRuntime;
import java.util.Optional;
import java.util.UUID;

public final class AuthDecider {
    public static Decision onFailure(String name, String ip) {
        Optional<UUID> p;
        Decision d = new Decision();
        boolean known = TrueuuidRuntime.NAME_REGISTRY.isKnownPremiumName(name);
        if (TrueuuidConfig.recentIpGraceEnabled() && (p = TrueuuidRuntime.IP_GRACE.tryGrace(name, ip, TrueuuidConfig.recentIpGraceTtlSeconds())).isPresent()) {
            d.kind = Decision.Kind.PREMIUM_GRACE;
            d.premiumUuid = p.get();
            return d;
        }
        if (known && TrueuuidConfig.knownPremiumDenyOffline()) {
            d.kind = Decision.Kind.DENY;
            d.denyMessage = "\u8be5\u540d\u79f0\u5df2\u7ed1\u5b9a\u6b63\u7248 UUID\uff0c\u9274\u6743\u5931\u8d25\u65f6\u4e0d\u5141\u8bb8\u4ee5\u79bb\u7ebf\u6a21\u5f0f\u8fdb\u5165\u3002\u8bf7\u68c0\u67e5\u7f51\u7edc\u540e\u91cd\u8bd5\u3002";
            return d;
        }
        if (TrueuuidConfig.allowOfflineForUnknownOnly() && !known) {
            d.kind = Decision.Kind.OFFLINE;
            return d;
        }
        d.kind = Decision.Kind.DENY;
        d.denyMessage = "\u9274\u6743\u5931\u8d25\uff0c\u5df2\u7981\u6b62\u79bb\u7ebf\u8fdb\u5165\u4ee5\u4fdd\u62a4\u4f60\u7684\u6b63\u7248\u5b58\u6863\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002";
        return d;
    }

    private AuthDecider() {
    }

    public static class Decision {
        public Kind kind;
        public UUID premiumUuid;
        public String denyMessage;

        public static enum Kind {
            PREMIUM_GRACE,
            OFFLINE,
            DENY;

        }
    }
}

