/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class NameRegistry {
    private final Path file;
    private final Map<String, Entry> map = new HashMap<String, Entry>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public NameRegistry() {
        this.file = FMLPaths.CONFIGDIR.get().resolve("trueuuid-registry.json");
        this.load();
    }

    public synchronized Optional<UUID> getPremiumUuid(String name) {
        Entry e = this.map.get(name.toLowerCase(Locale.ROOT));
        return e == null ? Optional.empty() : Optional.ofNullable(e.premiumUuid);
    }

    public synchronized boolean isKnownPremiumName(String name) {
        return this.map.containsKey(name.toLowerCase(Locale.ROOT));
    }

    public synchronized void recordSuccess(String name, UUID premiumUuid, String ip) {
        String k = name.toLowerCase(Locale.ROOT);
        Entry e = this.map.getOrDefault(k, new Entry());
        e.premiumUuid = premiumUuid;
        long now = Instant.now().toEpochMilli();
        if (e.firstVerifiedAt == 0L) {
            e.firstVerifiedAt = now;
        }
        e.lastVerifiedAt = now;
        e.lastSuccessIp = ip;
        this.map.put(k, e);
        this.saveAsync();
    }

    private void load() {
        block10: {
            try {
                if (!Files.exists(this.file, new LinkOption[0])) break block10;
                try (BufferedReader r = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                    JsonObject o = JsonParser.parseReader((Reader)r).getAsJsonObject();
                    for (String k : o.keySet()) {
                        JsonObject e = o.getAsJsonObject(k);
                        Entry en = new Entry();
                        en.premiumUuid = UUID.fromString(e.get("premiumUuid").getAsString());
                        en.firstVerifiedAt = e.get("firstVerifiedAt").getAsLong();
                        en.lastVerifiedAt = e.get("lastVerifiedAt").getAsLong();
                        if (e.has("lastSuccessIp")) {
                            en.lastSuccessIp = e.get("lastSuccessIp").getAsString();
                        }
                        this.map.put(k, en);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveAsync() {
        new Thread(this::save, "TrueUUID-RegistrySave").start();
    }

    private synchronized void save() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            JsonObject o = new JsonObject();
            for (Map.Entry<String, Entry> me : this.map.entrySet()) {
                JsonObject e = new JsonObject();
                e.addProperty("premiumUuid", me.getValue().premiumUuid.toString());
                e.addProperty("firstVerifiedAt", (Number)me.getValue().firstVerifiedAt);
                e.addProperty("lastVerifiedAt", (Number)me.getValue().lastVerifiedAt);
                if (me.getValue().lastSuccessIp != null) {
                    e.addProperty("lastSuccessIp", me.getValue().lastSuccessIp);
                }
                o.add(me.getKey(), (JsonElement)e);
            }
            try (BufferedWriter w = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.gson.toJson((JsonElement)o, (Appendable)w);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Entry {
        public UUID premiumUuid;
        public long firstVerifiedAt;
        public long lastVerifiedAt;
        public String lastSuccessIp;
    }
}

