/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.server;

import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class RecentIpGraceCache {
    private final Map<String, Rec> map = new HashMap<String, Rec>();

    private static String key(String name, String ip) {
        return name.toLowerCase(Locale.ROOT) + "|" + ip;
    }

    public synchronized void record(String name, String ip, UUID premiumUuid) {
        if (ip == null || ip.isEmpty()) {
            return;
        }
        Rec r = new Rec();
        r.premiumUuid = premiumUuid;
        r.lastSuccessAt = Instant.now().toEpochMilli();
        this.map.put(RecentIpGraceCache.key(name, ip), r);
    }

    public synchronized Optional<UUID> tryGrace(String name, String ip, int ttlSeconds) {
        if (ip == null || ip.isEmpty()) {
            return Optional.empty();
        }
        Rec r = this.map.get(RecentIpGraceCache.key(name, ip));
        if (r == null) {
            return Optional.empty();
        }
        long now = Instant.now().toEpochMilli();
        if (now - r.lastSuccessAt <= (long)ttlSeconds * 1000L) {
            return Optional.of(r.premiumUuid);
        }
        return Optional.empty();
    }

    public synchronized void cleanup(int ttlSeconds) {
        long now = Instant.now().toEpochMilli();
        this.map.entrySet().removeIf(e -> now - ((Rec)e.getValue()).lastSuccessAt > (long)ttlSeconds * 1000L);
    }

    private static class Rec {
        UUID premiumUuid;
        long lastSuccessAt;

        private Rec() {
        }
    }
}

