/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.trueuuid.server;

import cn.alini.trueuuid.config.TrueuuidConfig;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public final class SessionCheck {
    private static final HttpClient HTTP = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();

    public static Optional<HasJoinedResult> hasJoined(String username, String serverId, String ip) throws Exception {
        String url = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + URLEncoder.encode(username, StandardCharsets.UTF_8) + "&serverId=" + URLEncoder.encode(serverId, StandardCharsets.UTF_8);
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID][DEBUG] \u8bf7\u6c42 Mojang \u6821\u9a8c\u63a5\u53e3: " + url);
        }
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).GET().build();
        HttpResponse<String> resp = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID][DEBUG] Mojang \u54cd\u5e94\u72b6\u6001\u7801: " + resp.statusCode());
            System.out.println("[TrueUUID][DEBUG] Mojang \u54cd\u5e94\u5185\u5bb9: " + resp.body());
        }
        if (resp.statusCode() != 200) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID][DEBUG] \u6821\u9a8c\u5931\u8d25\uff0c\u72b6\u6001\u7801\u975e200\uff0c\u8fd4\u56de\u7a7a");
            }
            return Optional.empty();
        }
        HasJoinedJson dto = (HasJoinedJson)GSON.fromJson(resp.body(), HasJoinedJson.class);
        if (dto == null || dto.id == null) {
            if (TrueuuidConfig.debug()) {
                System.out.println("[TrueUUID][DEBUG] \u89e3\u6790JSON\u5931\u8d25\u6216\u672a\u83b7\u53d6\u5230UUID\uff0c\u8fd4\u56de\u7a7a");
            }
            return Optional.empty();
        }
        UUID uuid = UUID.fromString(dto.id.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{12})", "$1-$2-$3-$4-$5"));
        if (TrueuuidConfig.debug()) {
            System.out.println("[TrueUUID][DEBUG] \u6821\u9a8c\u6210\u529f\uff0cUUID: " + uuid + "\uff0c\u73a9\u5bb6\u540d: " + dto.name);
        }
        List<Property> props = dto.properties == null ? List.of() : dto.properties.stream().map(p -> new Property(p.name, p.value, p.sig)).toList();
        return Optional.of(new HasJoinedResult(uuid, dto.name, props));
    }

    private static class HasJoinedJson {
        String id;
        String name;
        List<Prop> properties;

        private HasJoinedJson() {
        }
    }

    public record HasJoinedResult(UUID uuid, String name, List<Property> properties) {
    }

    public record Property(String name, String value, String signature) {
    }

    private static class Prop {
        String name;
        String value;
        @SerializedName(value="signature")
        String sig;

        private Prop() {
        }
    }
}

