/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.network.Network;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NodeHost;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Direction;

public class NetworkNode<H extends NodeHost, C extends NetworkCache<H, C>> {
    private final H host;
    Network<H, C> network;
    private final List<Connection<H, C>> connections = new ArrayList<Connection<H, C>>();

    public NetworkNode(H host) {
        this.host = host;
    }

    public List<Connection<H, C>> getConnections() {
        return this.connections;
    }

    public H getHost() {
        return this.host;
    }

    public C getNetworkCache() {
        return this.network.cache;
    }

    void addConnection(Direction direction, NetworkNode<H, C> target) {
        for (Connection<H, C> connection : this.connections) {
            if (connection.direction() != direction) continue;
            throw new IllegalStateException("Connection already exists.");
        }
        this.connections.add(new Connection<H, C>(direction, target));
        ((NodeHost)this.host).onConnectedTo((NodeHost)target.getHost());
    }

    void removeConnection(Direction direction, NetworkNode<H, C> target) {
        Iterator<Connection<H, C>> it = this.connections.iterator();
        while (it.hasNext()) {
            Connection<H, C> connection = it.next();
            if (connection.direction() != direction) continue;
            if (connection.target() != target) {
                throw new IllegalStateException("Target mismatch!");
            }
            it.remove();
            return;
        }
        throw new IllegalStateException("Connection does not exist.");
    }

    void updateHostConnections() {
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Connection<H, C> connection : this.connections) {
            connections.add(connection.direction);
        }
        ((NodeHost)this.host).setConnections(connections);
    }

    public record Connection<H extends NodeHost, C extends NetworkCache<H, C>>(Direction direction, NetworkNode<H, C> target) {
    }
}

