/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public abstract class NodeHost {
    protected final PipeBlockEntity pipe;
    private final AttachedAttachment[] attachments = new AttachedAttachment[6];
    public byte pipeConnections = 0;
    public int inventoryConnections = 0;
    private boolean needsUpdate = true;

    protected NodeHost(PipeBlockEntity pipe) {
        this.pipe = pipe;
    }

    public Level getLevel() {
        return this.pipe.getLevel();
    }

    public BlockPos getPos() {
        return this.pipe.getBlockPos();
    }

    @Nullable
    public final AttachedAttachment removeAttachment(Direction side) {
        AttachedAttachment attachment = this.attachments[side.get3DDataValue()];
        if (attachment != null) {
            this.attachments[side.get3DDataValue()] = null;
            this.update();
            return attachment;
        }
        return null;
    }

    public final void setAttachment(Direction side, AttachmentItem item, CompoundTag data, HolderLookup.Provider registries) {
        AttachedAttachment current = this.attachments[side.get3DDataValue()];
        if (current != null && current.getItem() == item) {
            if (current.update(data)) {
                this.scheduleUpdate();
            }
        } else {
            this.attachments[side.get3DDataValue()] = item.createAttached(this, data, registries);
            this.scheduleUpdate();
            this.pipe.invalidateCapabilities();
        }
    }

    @Nullable
    public final AttachedAttachment getAttachment(Direction side) {
        return this.attachments[side.get3DDataValue()];
    }

    public abstract boolean acceptsAttachment(AttachmentItem var1, ItemStack var2);

    public final boolean isTicking() {
        return ((ServerLevel)this.pipe.getLevel()).isPositionEntityTicking(this.pipe.getBlockPos());
    }

    public boolean canConnectTo(Direction connectionDirection, NodeHost adjacentHost) {
        return (this.pipe.connectionBlacklist & 1 << connectionDirection.get3DDataValue()) == 0;
    }

    public final void setConnections(EnumSet<Direction> connections) {
        this.pipeConnections = SerializationHelper.directionsToMask(connections);
        this.pipe.sync();
    }

    public void onConnectedTo(NodeHost other) {
    }

    public void onConnectionRejectedTo(Direction direction, NodeHost other) {
    }

    public abstract NetworkManager getManager();

    public void addSelf() {
        this.getManager().addNode((ServerLevel)this.pipe.getLevel(), this.pipe.getBlockPos(), this);
    }

    public void removeSelf() {
        this.getManager().removeNode((ServerLevel)this.pipe.getLevel(), this.pipe.getBlockPos(), this);
    }

    public final void refreshSelf() {
        this.getManager().refreshNode((ServerLevel)this.pipe.getLevel(), this.pipe.getBlockPos(), this);
    }

    @Nullable
    public abstract Object getApiInstance(BlockCapability<?, Direction> var1, @Nullable Direction var2);

    @Nullable
    protected final <H extends NodeHost, C extends NetworkCache<H, C>> NetworkNode<H, C> findNode() {
        return this.getManager().findNode((ServerLevel)this.pipe.getLevel(), this.pipe.getBlockPos());
    }

    public final void separateNetwork() {
        @Nullable NetworkNode<H, C> node = this.findNode();
        if (node != null && node.getHost() == this) {
            ((NetworkCache)node.getNetworkCache()).separate();
        }
    }

    protected final void update() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.doUpdate();
        }
    }

    protected void doUpdate() {
    }

    public final void scheduleUpdate() {
        if (!this.needsUpdate) {
            this.needsUpdate = true;
            @Nullable NetworkNode<H, C> node = this.findNode();
            if (node != null) {
                ((NetworkCache)node.getNetworkCache()).scheduleHostUpdate(this);
            }
        }
    }

    public final boolean needsUpdate() {
        return this.needsUpdate;
    }

    public final PipeBlockEntity getPipe() {
        return this.pipe;
    }

    private boolean hasAttachments() {
        for (AttachedAttachment attachment : this.attachments) {
            if (attachment == null) continue;
            return true;
        }
        return false;
    }

    @MustBeInvokedByOverriders
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.hasAttachments()) {
            ListTag attachmentTags = new ListTag();
            for (AttachedAttachment attachment : this.attachments) {
                CompoundTag attachmentTag = new CompoundTag();
                if (attachment != null) {
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)attachment.getItem());
                    attachmentTag.putString("#i", id.toString());
                    attachment.writeConfigTag(attachmentTag, registries);
                }
                attachmentTags.add((Object)attachmentTag);
            }
            tag.put("attachments", (Tag)attachmentTags);
        }
    }

    @MustBeInvokedByOverriders
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("attachments", 9)) {
            ListTag attachmentTags = tag.getList("attachments", 10);
            for (int i = 0; i < this.attachments.length; ++i) {
                CompoundTag attachmentTag;
                Item item;
                this.attachments[i] = null;
                if (i >= attachmentTags.size() || !((item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(attachmentTag = attachmentTags.getCompound(i)).getString("#i")))) instanceof AttachmentItem)) continue;
                AttachmentItem attachmentItem = (AttachmentItem)item;
                this.attachments[i] = attachmentItem.createAttached(this, attachmentTag, registries);
            }
        }
    }

    @MustBeInvokedByOverriders
    public void writeClientNbt(CompoundTag tag, RegistryAccess registries) {
    }

    @MustBeInvokedByOverriders
    public void readClientNbt(CompoundTag tag, RegistryAccess registries) {
    }

    public void clientTick() {
    }

    public void onRemoved() {
    }

    public void addDrops(List<ItemStack> drops) {
        for (Direction side : Direction.values()) {
            AttachedAttachment attachment = this.getAttachment(side);
            if (attachment == null) continue;
            drops.addAll(attachment.getDrops());
        }
    }

    public String toString() {
        return super.toString() + "{pipe entity=" + String.valueOf((Object)this.pipe) + ", pipe pos=" + String.valueOf(this.pipe.getBlockPos()) + ", pipe level=" + String.valueOf(this.pipe.getLevel()) + "}";
    }
}

