/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.util.ItemVariant;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

final class InsertionOnlyItemHandler
implements IItemHandler {
    private final InsertionHandler handler;

    public InsertionOnlyItemHandler(InsertionHandler handler) {
        this.handler = handler;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        int maxAmount = stack.getCount();
        ItemVariant variant = ItemVariant.of(stack);
        int amountInserted = this.handler.handle(variant, maxAmount, simulate);
        if (amountInserted <= 0) {
            return stack;
        }
        int notInserted = maxAmount - amountInserted;
        if (notInserted > 0) {
            return variant.toStack(notInserted);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @FunctionalInterface
    public static interface InsertionHandler {
        public int handle(ItemVariant var1, int var2, boolean var3);
    }
}

