/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.packets;

import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterSimilarMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.gui.menu.AttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.FluidAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import dev.technici4n.moderndynamics.packets.SetAttachmentUpgrades;
import dev.technici4n.moderndynamics.packets.SetEnum;
import dev.technici4n.moderndynamics.packets.SetFluidVariant;
import dev.technici4n.moderndynamics.packets.SetInt;
import dev.technici4n.moderndynamics.packets.SetItemVariant;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.ItemVariant;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.function.BiConsumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class MdPackets {
    private static final CustomPacketPayload.Type<SetEnum<FilterInversionMode>> SET_FILTER_MODE = new CustomPacketPayload.Type(MdId.of("set_filter_mode"));
    private static final SetEnumHandler<FilterInversionMode> SET_FILTER_MODE_HANDLER = MdPackets.createSetEnumHandler(AttachedIoMenu.class, AttachedIoMenu::setFilterMode);
    private static final CustomPacketPayload.Type<SetEnum<FilterDamageMode>> SET_FILTER_DAMAGE = new CustomPacketPayload.Type(MdId.of("set_filter_damage"));
    private static final SetEnumHandler<FilterDamageMode> SET_FILTER_DAMAGE_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setFilterDamage);
    private static final CustomPacketPayload.Type<SetEnum<FilterNbtMode>> SET_FILTER_NBT = new CustomPacketPayload.Type(MdId.of("set_filter_nbt"));
    private static final SetEnumHandler<FilterNbtMode> SET_FILTER_NBT_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setFilterNbt);
    private static final CustomPacketPayload.Type<SetEnum<FilterModMode>> SET_FILTER_MOD = new CustomPacketPayload.Type(MdId.of("set_filter_mod"));
    private static final SetEnumHandler<FilterModMode> SET_FILTER_MOD_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setFilterMod);
    private static final CustomPacketPayload.Type<SetEnum<FilterSimilarMode>> SET_FILTER_SIMILAR = new CustomPacketPayload.Type(MdId.of("set_filter_similar"));
    private static final SetEnumHandler<FilterSimilarMode> SET_FILTER_SIMILAR_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setFilterSimilar);
    private static final CustomPacketPayload.Type<SetEnum<RoutingMode>> SET_ROUTING_MODE = new CustomPacketPayload.Type(MdId.of("set_routing_mode"));
    private static final SetEnumHandler<RoutingMode> SET_ROUTING_MODE_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setRoutingMode);
    private static final CustomPacketPayload.Type<SetEnum<OversendingMode>> SET_OVERSENDING_MODE = new CustomPacketPayload.Type(MdId.of("set_oversending_mode"));
    private static final SetEnumHandler<OversendingMode> SET_OVERSENDING_MODE_HANDLER = MdPackets.createSetEnumHandler(ItemAttachedIoMenu.class, ItemAttachedIoMenu::setOversendingMode);
    private static final CustomPacketPayload.Type<SetEnum<RedstoneMode>> SET_REDSTONE_MODE = new CustomPacketPayload.Type(MdId.of("set_redstone_mode"));
    private static final SetEnumHandler<RedstoneMode> SET_REDSTONE_MODE_HANDLER = MdPackets.createSetEnumHandler(AttachedIoMenu.class, AttachedIoMenu::setRedstoneMode);
    private static final CustomPacketPayload.Type<SetInt> SET_MAX_ITEMS_IN_INVENTORY = new CustomPacketPayload.Type(MdId.of("set_max_items_in_inventory"));
    private static final SetIntHandler SET_MAX_ITEMS_IN_INVENTORY_HANDLER = MdPackets.createSetIntHandler(ItemAttachedIoMenu::setMaxItemsInInventory);
    private static final CustomPacketPayload.Type<SetInt> SET_MAX_ITEMS_EXTRACTED = new CustomPacketPayload.Type(MdId.of("set_max_items_extracted"));
    private static final SetIntHandler SET_MAX_ITEMS_EXTRACTED_HANDLER = MdPackets.createSetIntHandler(ItemAttachedIoMenu::setMaxItemsExtracted);

    public static void sendSetFilter(int syncId, int filterSlot, ItemVariant variant) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetItemVariant(syncId, filterSlot, variant), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSetFilter(int syncId, int filterSlot, FluidVariant variant) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetFluidVariant(syncId, filterSlot, variant), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSetFilterMode(int syncId, FilterInversionMode filterMode) {
        MdPackets.sendSetEnum(syncId, SET_FILTER_MODE, filterMode);
    }

    public static void sendSetFilterDamage(int syncId, FilterDamageMode value) {
        MdPackets.sendSetEnum(syncId, SET_FILTER_DAMAGE, value);
    }

    public static void sendSetFilterNbt(int syncId, FilterNbtMode value) {
        MdPackets.sendSetEnum(syncId, SET_FILTER_NBT, value);
    }

    public static void sendSetFilterMod(int syncId, FilterModMode value) {
        MdPackets.sendSetEnum(syncId, SET_FILTER_MOD, value);
    }

    public static void sendSetFilterSimilar(int syncId, FilterSimilarMode value) {
        MdPackets.sendSetEnum(syncId, SET_FILTER_SIMILAR, value);
    }

    public static void sendSetRoutingMode(int syncId, RoutingMode value) {
        MdPackets.sendSetEnum(syncId, SET_ROUTING_MODE, value);
    }

    public static void sendSetOversendingMode(int syncId, OversendingMode value) {
        MdPackets.sendSetEnum(syncId, SET_OVERSENDING_MODE, value);
    }

    public static void sendSetRedstoneMode(int syncId, RedstoneMode value) {
        MdPackets.sendSetEnum(syncId, SET_REDSTONE_MODE, value);
    }

    public static void sendSetMaxItemsInInventory(int syncId, int value) {
        MdPackets.sendSetInt(syncId, SET_MAX_ITEMS_IN_INVENTORY, value);
    }

    public static void sendSetMaxItemsExtracted(int syncId, int value) {
        MdPackets.sendSetInt(syncId, SET_MAX_ITEMS_EXTRACTED, value);
    }

    private static <T extends Enum<T>> void sendSetEnum(int syncId, CustomPacketPayload.Type<SetEnum<T>> packetType, T enumValue) {
        PacketDistributor.sendToServer(new SetEnum<T>(packetType, syncId, enumValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static <T extends Enum<T>, M extends AbstractContainerMenu> SetEnumHandler<T> createSetEnumHandler(Class<M> menuClass, EnumSetter<T, M> setter) {
        return (player, syncId, value) -> {
            AbstractContainerMenu handler = player.containerMenu;
            if (handler.containerId == syncId) {
                setter.setEnum((AbstractContainerMenu)menuClass.cast(handler), value, false);
            }
        };
    }

    private static void sendSetInt(int syncId, CustomPacketPayload.Type<SetInt> packetType, int value) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetInt(packetType, syncId, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static SetIntHandler createSetIntHandler(IntSetter setter) {
        return (player, syncId, value) -> {
            AbstractContainerMenu handler = player.containerMenu;
            if (handler.containerId == syncId && handler instanceof ItemAttachedIoMenu) {
                ItemAttachedIoMenu attachmentMenu = (ItemAttachedIoMenu)handler;
                setter.setInt(attachmentMenu, value, false);
            }
        };
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToClient(SetAttachmentUpgrades.TYPE, SetAttachmentUpgrades.STREAM_CODEC, SetAttachmentUpgrades.HANDLER);
        registrar.playBidirectional(SetItemVariant.TYPE, SetItemVariant.STREAM_CODEC, MdPackets.handler(MdPackets::handleSetItemVariant));
        registrar.playBidirectional(SetFluidVariant.TYPE, SetFluidVariant.STREAM_CODEC, MdPackets.handler(MdPackets::handleSetFluidVariant));
        MdPackets.registerSetEnum(registrar, SET_FILTER_MODE, FilterInversionMode.class, SET_FILTER_MODE_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_FILTER_DAMAGE, FilterDamageMode.class, SET_FILTER_DAMAGE_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_FILTER_NBT, FilterNbtMode.class, SET_FILTER_NBT_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_FILTER_MOD, FilterModMode.class, SET_FILTER_MOD_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_FILTER_SIMILAR, FilterSimilarMode.class, SET_FILTER_SIMILAR_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_ROUTING_MODE, RoutingMode.class, SET_ROUTING_MODE_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_OVERSENDING_MODE, OversendingMode.class, SET_OVERSENDING_MODE_HANDLER);
        MdPackets.registerSetEnum(registrar, SET_REDSTONE_MODE, RedstoneMode.class, SET_REDSTONE_MODE_HANDLER);
        MdPackets.registerSetInt(registrar, SET_MAX_ITEMS_IN_INVENTORY, SET_MAX_ITEMS_IN_INVENTORY_HANDLER);
        MdPackets.registerSetInt(registrar, SET_MAX_ITEMS_EXTRACTED, SET_MAX_ITEMS_EXTRACTED_HANDLER);
    }

    private static <T extends Enum<T>> void registerSetEnum(PayloadRegistrar registrar, CustomPacketPayload.Type<SetEnum<T>> type, Class<T> enumClass, SetEnumHandler<T> handler) {
        registrar.playBidirectional(type, SetEnum.codec(type, enumClass), MdPackets.handler((player, payload) -> handler.handleSetEnum((Player)player, payload.syncId(), payload.value())));
    }

    private static void registerSetInt(PayloadRegistrar registrar, CustomPacketPayload.Type<SetInt> type, SetIntHandler handler) {
        registrar.playBidirectional(type, SetInt.codec(type), MdPackets.handler((player, payload) -> handler.handleSetInt((Player)player, payload.syncId(), payload.value())));
    }

    private static void handleSetItemVariant(Player player, SetItemVariant payload) {
        AbstractContainerMenu handler = player.containerMenu;
        if (handler.containerId == payload.syncId() && handler instanceof ItemAttachedIoMenu) {
            ItemAttachedIoMenu attachmentMenu = (ItemAttachedIoMenu)handler;
            attachmentMenu.setFilter(payload.configIdx(), payload.variant(), false);
        }
    }

    private static void handleSetFluidVariant(Player player, SetFluidVariant payload) {
        AbstractContainerMenu handler = player.containerMenu;
        if (handler.containerId == payload.syncId() && handler instanceof FluidAttachedIoMenu) {
            FluidAttachedIoMenu attachmentMenu = (FluidAttachedIoMenu)handler;
            attachmentMenu.setFilter(payload.configIdx(), payload.variant(), false);
        }
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> handler(BiConsumer<Player, T> handler) {
        return (payload, context) -> handler.accept(context.player(), payload);
    }

    private static interface EnumSetter<T extends Enum<T>, M extends AbstractContainerMenu> {
        public void setEnum(M var1, T var2, boolean var3);
    }

    @FunctionalInterface
    static interface SetEnumHandler<T> {
        public void handleSetEnum(Player var1, int var2, T var3);
    }

    private static interface IntSetter {
        public void setInt(ItemAttachedIoMenu var1, int var2, boolean var3);
    }

    @FunctionalInterface
    static interface SetIntHandler {
        public void handleSetInt(Player var1, int var2, int var3);
    }
}

