/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class SerializationHelper {
    public static byte directionsToMask(EnumSet<Direction> directions) {
        byte result = 0;
        for (Direction direction : directions) {
            result = (byte)(result | 1 << direction.get3DDataValue());
        }
        return result;
    }

    public static EnumSet<Direction> directionsFromMask(byte mask) {
        EnumSet<Direction> result = EnumSet.noneOf(Direction.class);
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) <= 0) continue;
            result.add(Direction.from3DDataValue((int)i));
        }
        return result;
    }

    public static CompoundTag posToNbt(BlockPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("x", pos.getX());
        nbt.putInt("y", pos.getY());
        nbt.putInt("z", pos.getZ());
        return nbt;
    }

    public static BlockPos posFromNbt(CompoundTag nbt) {
        return new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
    }

    public static String encodePath(Direction[] path) {
        StringBuilder encoded = new StringBuilder();
        for (Direction direction : path) {
            encoded.append(direction.getName().charAt(0));
        }
        return encoded.toString();
    }

    public static Direction[] decodePath(String encoded) {
        Direction[] path = new Direction[encoded.length()];
        for (int i = 0; i < encoded.length(); ++i) {
            Direction direction2;
            block3: {
                for (Direction direction2 : Direction.values()) {
                    if (direction2.getName().charAt(0) != encoded.charAt(i)) {
                        continue;
                    }
                    break block3;
                }
                throw new RuntimeException("Unkown direction character in path: " + encoded.charAt(i));
            }
            path[i] = direction2;
        }
        return path;
    }
}

