/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.client.entities.wagon;

import com.dragn0007.dragnlivestock.LivestockOverhaul;
import com.dragn0007.dragnlivestock.entities.wagon.base.AbstractGeckolibVehicle;
import com.dragn0007.dragnlivestock.entities.wagon.base.AbstractWagon;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class WagonModel<T extends AbstractWagon>
extends DefaultedEntityGeoModel<T> {
    private final String subpath;

    public WagonModel(String subpath) {
        super(new ResourceLocation("dragnlivestock", "wagon/" + subpath), false);
        this.subpath = subpath;
    }

    public ResourceLocation getTextureResource(T wagon) {
        return LivestockOverhaul.id("textures/entity/wagon/" + ((AbstractWagon)((Object)wagon)).getWoodType().toString().toLowerCase() + "_" + this.subpath + ".png");
    }

    public void setCustomAnimations(T wagon, long instanceId, AnimationState<T> state) {
        super.setCustomAnimations(wagon, instanceId, state);
        AnimationProcessor processor = this.getAnimationProcessor();
        float partialTick = (float)state.animationTick - (float)((int)state.animationTick);
        float rot = ((AbstractGeckolibVehicle)((Object)wagon)).getWheelRot(partialTick);
        processor.getBone("FrontWheels").setRotX(-rot);
        processor.getBone("BackWheels").setRotX(-rot);
    }
}

